package cn.myapps.versions.service;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.AbstractDesignTimeService;
import cn.myapps.common.CommonDAO;
import cn.myapps.common.Environment;
import cn.myapps.common.ModelSuffix;
import cn.myapps.common.dao.versions.FileSystemVersionsDAO;
import cn.myapps.common.dao.versions.VersionsDAO;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.versions.Versions;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.upgrade.service.UpgradeService;
import cn.myapps.upgrade.service.UpgradeServiceImpl;
import cn.myapps.upgrade.util.UpgradeConstant;
import cn.myapps.util.sequence.Sequence;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

import javax.sql.DataSource;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.util.*;

public class VersionsServiceImpl extends AbstractDesignTimeService<Versions> implements VersionsService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Override
	protected CommonDAO<Versions> getDao() {
		return new FileSystemVersionsDAO(Versions.class);
	}

	public Collection<Versions> queryByVersionAndType(String name, String number, int type) throws Exception {
		return ((FileSystemVersionsDAO) getDao()).queryByVersionAndType(name, number, type);
	}

	public void doRecordVersions(Versions vo) throws Exception {
		if (vo != null) {
			Collection<Versions> cols = queryByVersionAndType(vo.getVersion_name(), vo.getVersion_number(),
					vo.getType());
			if (cols == null || cols.isEmpty()) {
				try {
					PersistenceUtils.beginTransaction();
					vo.setId(Sequence.getDesignTimeSequence());
					getDao().save(vo);
					PersistenceUtils.commitTransaction();
				} catch (Exception e) {
					e.printStackTrace();
					PersistenceUtils.rollbackTransaction();
				}
			}
		}
	}

	public Collection<Versions> queryByType(int type) throws Exception {
		return ((VersionsDAO) getDao()).queryByType(type);
	}

	public Versions findCurrVersionByType(int type) throws Exception {
		Versions vo = null;
		Collection<Versions> cols = this.queryByType(type);
		if (cols != null && !cols.isEmpty()) {
			vo = cols.iterator().next();
		}
		return vo;
	}
	
	private DataSource getDataSource(String applicationId) throws Exception {

		DataSource dataSource =  null;
		{
			ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
			Application app = (Application) service.findById(applicationId);
			
			cn.myapps.common.model.datasource.DataSource ds = app.getDataSourceDefine();
			//System.out.println(ds);
//			DataSource runTimeDataSource = null;
//			try{
//			    runTimeDataSource = (DataSource) SpringApplicationContextUtil.getBean("testRuntimeDataSource");
//			} catch (NullPointerException e){
//				// 未处于测试环境下，spring上下文没有初始化。
//			} catch (BeansException e){
//				LOG.debug("{}", e.getMessage());
//				// 未查到测试环境下的 DataSource
//			}
//			if(runTimeDataSource != null){//如果为测试环境时，运行时的数据源使用测试环境的数据源。
//				dataSource = runTimeDataSource;
//			}
			
			if (ds != null && dataSource == null) {
				
					String username = ds.getUsername();
					String password = ds.getPassword();
					String driver = ds.getDriverClass();
					String url = ds.getUrl();
					String poolsize = !StringUtils.isBlank(ds.getPoolsize()) ? ds.getPoolsize() : "10";
					String timeout = !StringUtils.isBlank(ds.getTimeout()) ? ds.getTimeout() : "5000";
	
	//				dataSource = PersistenceUtils.getC3P0DataSource(username, password, driver, url, poolsize, timeout);
					dataSource = PersistenceUtils.getDruidDataSource(app.getName(),username, password, driver, url, poolsize, timeout);
	//				dataSource = PersistenceUtils.getProxoolDataSource(username, password, driver, url, poolsize, timeout);
			}
		}

		return dataSource;
	}

	@Override
	public String doUpgrade2FileSystem() throws Exception {

		JSONObject result = new JSONObject();

		boolean status = false;
		String message = null;
		String datas = null;

		boolean isAppExist = false;
		// 系统是否已经被迁移(存在迁移信息 -- 提示删除)
		isAppExist = isAppExist();

		if (!isAppExist) {
			// 迁移系统(并获取相关的迁移信息)
			UpgradeService ups = new UpgradeServiceImpl();
			String doUpGrade = ups.doUpGrade();
			JSONArray resultList = new JSONArray();
			// System.out.println("-----------------迁移方法结束------------------");
			JSONArray arrays = JSONArray.fromObject(doUpGrade);
			for (int index = 0; index < arrays.size(); index++) {
				JSONObject msg = arrays.getJSONObject(index);
				boolean flag = msg.getBoolean("isError");
				if (flag) {
					resultList.add(msg);
				}
			}
			if (resultList.size() == 0) {
				status = true;
				message = UpgradeConstant.UPGRADE_MSG_SUCCESS;
			} else {
				status = false;
				message = UpgradeConstant.UPGRADE_MSG_FAIL_DATA;
				datas = resultList.toString();
			}
		} else {
			status = false;
			message = UpgradeConstant.UPGRADE_MSG_FAIL_APP_EXIST;
		}

		// System.out.println("-----------------迁移结束----------------");

		result.put("status", status);
		result.put("message", message);
		result.put("datas", datas);

		if (status) {
			// 添加版本升级信息
			Versions vo = new Versions();
			vo.setId(Sequence.getUUID());
			vo.setVersion_number("WeiOA365 2.0_UPGRADE");
			vo.setVersion_name("WeiOA365 2.0_UPGRADE");
			vo.setName("WeiOA365 2.0_UPGRADE");
			vo.setUpgrade_date(new Date());
			vo.setRemark(UpgradeConstant.UPGRADE_MSG_MAP.get(message));
			vo.setType(Versions.TYPE_TEMPLATE_UPGRADE);

			try {
				PersistenceUtils.beginTransaction();
				getDao().save(vo);
				PersistenceUtils.commitTransaction();
			} catch (Exception e) {
				e.printStackTrace();
				PersistenceUtils.rollbackTransaction();
			}
		}
		return result.toString();
	}

	public boolean isUpgradeSuccess() throws Exception {
		Collection<Versions> versions = this.queryByVersionAndType("WeiOA365 2.0_UPGRADE", "WeiOA365 2.0_UPGRADE",
				Versions.TYPE_TEMPLATE_UPGRADE);
		return !versions.isEmpty();
	}

	/**
	 * 判断系统是否已经被迁移:判断条件，workspace下是否存在软件
	 * 
	 * @return
	 * @throws Exception
	 */
	private boolean isAppExist() throws Exception {

		boolean isAppExist = true;
		String WORKSPACE_ROOT_PATH = Environment.getInstance().getWorkspaceRootPath();
		File root = new File(WORKSPACE_ROOT_PATH);
		if (root.exists()) {
			Collection<File> xmlFiles = new ArrayList<File>();
			File[] apps = root.listFiles();
			for (File app : apps) {
				File[] listFiles = app.listFiles(new FilenameFilter() {
					@Override
					public boolean accept(File dir, String name) {
						boolean accept = false;
						if (name.equals("Default.application") || name.equals("KM.application")) {
							accept = false;
						} else if (name.lastIndexOf(".application") > 0) {
							accept = true;
						}
						return accept;
					}
				});

				if (listFiles != null) {
					for (File xml : listFiles) {
						xmlFiles.add(xml);
					}
				}
			}
			if (xmlFiles.size() == 0) {
				isAppExist = false;
			}
		} else {
			root.createNewFile();
			isAppExist = false;
		}
		return isAppExist;
	}

	@Override
	public String doClearFileSystem() throws Exception {
		UpgradeService ups = new UpgradeServiceImpl();
		String result = ups.doClear();

		// 添加版本升级信息
		JSONObject _result = JSONObject.fromObject(result);
		String message = _result.getString("message");
		Versions vo = new Versions();
		vo.setId(Sequence.getUUID());
		vo.setVersion_name("WeiOA365 2.0");
		vo.setVersion_number("");
		vo.setUpgrade_date(new Date());
		vo.setName(Sequence.getUUID());
		vo.setType(Versions.TYPE_SOURCECODE_UPGRADE);
		vo.setRemark(message);

		try {
			PersistenceUtils.beginTransaction();
			getDao().save(vo);
			PersistenceUtils.commitTransaction();
		} catch (Exception e) {
			e.printStackTrace();
			PersistenceUtils.rollbackTransaction();
		}

		return result;
	}

	public DataPackage<Versions> query(String parentId, String name, Integer type, int page, int lines)
			throws Exception {
		DataPackage<Versions> dp = new DataPackage<Versions>();

		try {

			List<Versions> list = getDao().queryByName(parentId, ModelSuffix.VERSIONS_PATH_SUFFIX,
					ModelSuffix.VERSIONS_FILE_SUFFIX, "");

			Iterator<Versions> iterator = list.iterator();

			if (name != null && !"".equals(name)) {
				while (iterator.hasNext()) {
					Versions version = iterator.next();

					String versionName = version.getVersion_name();

					if (versionName != null && !versionName.equals("")) {
						if (!versionName.contains(name)) {
							iterator.remove();
						}
					} else {
						iterator.remove();
					}
				}
			}

			if (type != null) {
				if (type.intValue() != 0) {
					iterator = list.iterator();

					while (iterator.hasNext()) {
						if (!(iterator.next().getType() == type.intValue())) {
							iterator.remove();
						}
					}
				}
			}

			dp.setRowCount(list.size());
			dp.setPageNo(page);
			dp.setLinesPerPage(lines);
			dp.setDatas(listPage(list, page, lines));
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}

		return dp;
	}

	private List<Versions> listPage(List<Versions> data, int page, int lines) {
		/** 总数据条数 */
		int totalCount = data.size();
		/** 总页数 */
		int totalPage = (totalCount + lines - 1) / lines;
		/** 上一页 */
		int lastPage = page - 1 > 1 ? page - 1 : 1;
		/** 下一页 */
		int nextPage = page >= totalPage ? totalPage : page + 1;

		int fromIndex = (page - 1) * lines;
		if (fromIndex >= data.size()) {
			return Collections.emptyList();// 空数组
		}
		if (fromIndex < 0) {
			return Collections.emptyList();// 空数组
		}
		int toIndex = page * lines;
		if (toIndex >= data.size()) {
			toIndex = data.size();
		}
		return data.subList(fromIndex, toIndex);
	}

	@Override
	protected String getPathSuffix() {
		return ModelSuffix.VERSIONS_PATH_SUFFIX;
	}

	@Override
	protected String getFileSuffix() {
		return ModelSuffix.VERSIONS_FILE_SUFFIX;
	}

	@Override
	public String doUpgradeData() throws Exception {
		ApplicationDesignTimeService process = DesignTimeServiceManager.applicationDesignTimeService();

		Collection<Application> apps = process.list(null, null);

		for (Application app : apps) {
			DataSource dataSource = getDataSource(app.getId());
			if (dataSource != null) {
				try(Connection conn = dataSource.getConnection()) {
					if (conn != null)
						((FileSystemVersionsDAO) getDao()).upgradeDynaTableDocid(conn, app.getId());
				}
			}
		}

		System.out.println("################ 数据转换成功！################");
		return null;
	}
}
