package cn.myapps.upgrade.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.myapps.common.util.StringUtil;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import net.sf.json.JSONObject;


public class LogHelper {

	private static final Logger logger = LoggerFactory.getLogger(LogHelper.class);
	
    private  static Collection<UpgradeMessage> list = new ArrayList<UpgradeMessage>();
    
    /**
     * 初始化List，防止冗余数据
     */
    public static void initList(){
    	if(list.size() > 0){
    		list.clear();
    	}
    }

	/**
	 * 捕获错误信息
	 * @param obj
	 * @param action
	 * @param exceptionMsg
	 * @return
	 */
	public static void setError(FileSystemDesignTimeSerializable obj , String action ,String exceptionMsg ,boolean isError){
		
		UpgradeMessage ugm = new UpgradeMessage();
		ugm.setAction(action);
		ugm.setError(isError);
		ugm.setFile(obj);
		ugm.setExceptionMsg(exceptionMsg);
		list.add(ugm);
	}
	
	/**
	 * 返回错误信息集合:JSONArray
	 * @return
	 */
	public static Collection<UpgradeMessage> getErrorList(){
		return list ;
	}
	
	/**
	 * 界面返回错误信息
	 * 
	 * 格式：
	         ID  /  名称       /   类型     /  位置      /  迁移报错信息     /  严重性    /   建议      /  
	 * @param upgradeMessage
	 * @return
	 */
	public static String getErrorMsg(UpgradeMessage upgradeMessage){
		
		JSONObject result = new JSONObject();
		
		FileSystemDesignTimeSerializable file = upgradeMessage.getFile();
		result.put("ID", file.getId());
		result.put("Name", file.getName());
		String position = getFilePosition(file.getPath());
		result.put("Position", position);
		String type = file.getClass().getSimpleName();
		result.put("Type", UpgradeConstant.TYPE_MAP.get(type));
		result.put("ErrMsg", upgradeMessage.getExceptionMsg());
		result.put("isError", upgradeMessage.isError());
		result.put("Advice", "");
		return result.toString();
	}

	/**
	 * 获取文件定位
	 * @param path
	 * @return
	 */
	private static String getFilePosition(String path) {
		
		String result = "无法定位";
		try {
			StringBuffer sb = new StringBuffer();
			if(!StringUtil.isBlank(path)){
				String[] split = path.split("\\\\WEB-INF\\\\workspace\\\\");
				String filePath = split[1];
				if(!StringUtil.isBlank(filePath)){
					String[] paths = filePath.split("\\\\");
					for(String _path : paths){
						String[] fileName = _path.split("\\.");
						String name = fileName[0];
						sb.append(name).append(File.separator);
					}
				}
				if(sb.length() > 1){
					result = sb.substring(0, sb.length()-1);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}
}


