package cn.myapps.upgrade.util;

import java.sql.Connection;

import cn.myapps.upgrade.dao.DB2UpgradeDAO;
import cn.myapps.upgrade.dao.MsSqlUpgradeDAO;
import cn.myapps.upgrade.dao.MySqlUpgradeDAO;
import cn.myapps.upgrade.dao.OracleUpgradeDAO;
import cn.myapps.upgrade.dao.PostgreSQLUpgradeDAO;
import cn.myapps.upgrade.dao.UpgradeDao;

public class DaoManager {
	
	public static UpgradeDao getUpGradeDAO() throws Exception {

		try (Connection conn = ConnectionManager.getConnection()) {
			String dbType = ConnectionManager.dbType;

			if ("MSSQL".equals(dbType)) {
				return new MsSqlUpgradeDAO(conn);
			} else if ("ORACLE".equals(dbType)) {
				return new OracleUpgradeDAO(conn);
			} else if ("DB2".equals(dbType)) {
				return new DB2UpgradeDAO(conn);
			} else if ("MYSQL".equals(dbType)) {
				return new MySqlUpgradeDAO(conn);
			} else if ("PostgreSQL".equals(dbType)) {
				return new PostgreSQLUpgradeDAO(conn);
			}
			return null;
		}
	}
}
