package cn.myapps.upgrade.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.myapps.common.util.SpringApplicationContextUtil;


/**
 * 数据库连接管理器
 * <p>管理Connection 对象的创建、缓存、关闭</p>
 * 
 * @author Happy
 *
 */
public class ConnectionManager {
	
	private final static Logger log = LoggerFactory.getLogger(ConnectionManager.class);

	public static final ThreadLocal<Connection> runtimeDBConn = new ThreadLocal<Connection>();
	
	private static DataSource ds = null;
	
	public static String dbType = "MYSQL";
	
	/**
	 * 获取数据库连接对象
	 * @return
	 * 		java.sql.Connection
	 * @throws Exception
	 */
	public static Connection getConnection() throws Exception {
		Connection threadLocal = runtimeDBConn.get();
		Connection conn = null;
		if (threadLocal != null) {
			conn = threadLocal;
		}
		if (conn == null || conn.isClosed()) {
			conn = newConnection();
			if(conn !=null)
				runtimeDBConn.set(conn);
		}
		
		return conn;
	}
	
	/**
	 * 实例化数据库连接对象
	 * <p>读取“proxool.properties”文件获取obpm系统库的数据源信息，创建数据库连接对象。</p>
	 * @return
	 * 		java.sql.Connection
	 * @throws Exception
	 */
	private static Connection newConnection() throws Exception {
		if (ds == null) {
			ds = SpringApplicationContextUtil.getBean(javax.sql.DataSource.class);
		}
		if(ds != null){
			return ds.getConnection();
		}
		return null;
	}
	
	/**
	 * 关闭Statement
	 * @param stmt
	 * @throws Exception
	 */
	public static void closeStatement(Statement stmt) throws Exception {
		try {
			if (stmt != null) {
				stmt.close();
			}
		} catch (SQLException se) {
			throw new Exception("SQL Exception while closing " + "Statement : \n" + se);
		}
	}
	
	/**
	 * 关闭数据库连接
	 * @throws Exception
	 */
	public static void closeConnection() throws Exception {
		try {
			Connection threadLocal = runtimeDBConn.get();
			if (threadLocal != null) {
					if (!threadLocal.isClosed()) {
						threadLocal.close();
					}
				threadLocal = null;
				
				runtimeDBConn.set(null);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}
}
