package cn.myapps.upgrade.gui;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class SiteIdGenerator {
	public static synchronized String getMACAddress() {

		try {
			// ��������ǰ�mac��ַƴװ��String
			StringBuffer sb = new StringBuffer();
			byte[] mac = getHardwareAddress(false, false);
			if (mac.length <= 1) {
				mac = getHardwareAddress(false, true);
			}
			if (mac.length <= 1) {
				mac = getHardwareAddress(true, false);
			}
			if (mac.length <= 1) {
				mac = getHardwareAddress(true, true);
			}
			for (int i = 0; i < mac.length; i++) {
				// mac[i] & 0xFF ��Ϊ�˰�byteת��Ϊ������
				// String s = Integer.toHexString(mac[i] & 0xFF);

				int n = mac[i] & 0xFF << 8 | mac[i++] & 0xFF;
				String s = Integer.toString(n, 35);
				sb.append(s);
				// sb.append(s.length() == 1 ? 0 + s : s);
			}
			// ���ַ�������Сд��ĸ��Ϊ��д��Ϊ�����mac��ַ������
			return "Z" + (sb.toString().toUpperCase());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	private static byte[] getHardwareAddress(boolean includeSoftEther, boolean abs) throws Exception {
		byte[] mac = new byte[] { 0 };
		Enumeration netInterfaces;
		InetAddress ia = null;
		netInterfaces = NetworkInterface.getNetworkInterfaces();
		while (netInterfaces.hasMoreElements()) {
			NetworkInterface ni = (NetworkInterface) netInterfaces.nextElement();
			Enumeration nii = ni.getInetAddresses();

			while (nii.hasMoreElements()) {
				ia = (InetAddress) nii.nextElement();
				// �������ӿڶ��󣨼������������õ�mac��ַ��mac��ַ������һ��byte�����С�
				NetworkInterface nf = NetworkInterface.getByInetAddress(ia);
				if (nf == null || nf.getDisplayName() == null
						|| (!includeSoftEther && (nf.getDisplayName().indexOf("VMware") != -1
								|| nf.getDisplayName().indexOf("Microsoft") != -1))) {
					continue;
				}

				if (nf.isVirtual() || nf.isLoopback() || nf.isPointToPoint())
					continue;

				byte[] tempMac = nf.getHardwareAddress();

				if (tempMac == null)
					continue;

				if (abs) {
					if (new BigInteger(tempMac).abs().compareTo(new BigInteger(mac).abs()) >= 0) {
						mac = tempMac;
					}
				} else {
					if (new BigInteger(tempMac).compareTo(new BigInteger(mac)) >= 0) {
						mac = tempMac;
					}
				}
			}
		}

		return mac;
	}

}
