package cn.myapps.upgrade.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class InstallerServiceWizad extends JFrame {
	private static final long serialVersionUID = 6728384305144121431L;

	/**
	 * 读取输出流数据
	 * 
	 * @param p 进程
	 * @return 从输出流中读取的数据
	 * @throws IOException
	 */
	public static final String getShellOut(Process p) throws IOException {

		StringBuilder sb = new StringBuilder();
		BufferedInputStream in = null;
		BufferedReader br = null;

		try {

			in = new BufferedInputStream(p.getInputStream());
			br = new BufferedReader(new InputStreamReader(in));
			String s;

			while ((s = br.readLine()) != null) {
				// 追加换行符
				sb.append(System.lineSeparator());
				sb.append(s);
			}

		} catch (IOException e) {
			throw e;
		} finally {
			br.close();
			in.close();
		}

		return sb.toString();
	}

	public static final synchronized void exec(String[] cmd) {
        //执行命令    
        Process p;
		try {
			p = Runtime.getRuntime().exec(cmd);
		       //取得命令结果的输出流    
	        InputStream fis=p.getInputStream();    
	       //用一个读输出流类去读    
	        InputStreamReader isr=new InputStreamReader(fis);    
	       //用缓冲器读行    
	        BufferedReader br=new BufferedReader(isr);    
	        String line=null;    
	       //直到读完为止    
	       while((line=br.readLine())!=null)    
	        {    
	            System.out.println(line);    
	        }    
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}    

	}
	
	/**
	 * 生成windows下服务安装需要的xml配置文件
	 * @param name
	 * @throws IOException
	 */
	public static void generateWinswConf(String name, String siteId, String storageRootPath, String javaOpts) throws IOException {
		File file = new File(name+".xml");
		FileWriter fw = new FileWriter(file);
		
		String path = System.getProperty("user.dir");
		
		String template = 
				"<configuration>\r\n" + 
				"  <id>"+ name +"</id>\r\n" + 
				"  <name>"+ name +"</name>\r\n" + 
				"  <description>This is a "+ name +" for myApps.</description>\r\n" + 
				"  <env name=\"JAVA_HOME\" value=\"%JAVA_HOME%\"/>\r\n" + 
				"  <executable>java</executable>\r\n" + 
				"  <arguments>-server " + (javaOpts==null?"":javaOpts) + " -jar \"" + path + "\\" + name +".jar\" --myapps.siteid=" + siteId + 
				(storageRootPath==null ? "" : " --myapps.storage.root=" + storageRootPath) + 
				" </arguments>\r\n" + 
				"  <startmode>Automatic</startmode>\r\n" + 
				"  <logpath>%BASE%\\log</logpath>\r\n" + 
				"  <logmode>rotate</logmode>\r\n" + 
				"</configuration>\r\n" ;
		
		fw.write(template);
		fw.close();
	}
	
	private String storageRootPath;
	private JTextField rootTextField;
	
	InstallerServiceWizad() {
		String siteId = SiteIdGenerator.getMACAddress();
		
		
		JFrame frame = new JFrame("myApps service installer"); // 创建Frame窗口
		JPanel panel = new JPanel(); // 面板1
		
		JLabel label = new JLabel("选择工作目录："); 
		panel.add(label);
		JTextField rootTextField = new JTextField(20);
		rootTextField.setEnabled(false);  
		panel.add(rootTextField);
		
		JButton open=new JButton("open");
		
		open.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
				JFileChooser jfc=new JFileChooser();
				jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				jfc.showDialog(new JLabel(), "选择");
				File file=jfc.getSelectedFile();
				if(file.isDirectory()){
					System.out.println("文件夹:"+file.getAbsolutePath());
				}else if(file.isFile()){
					System.out.println("文件:"+file.getAbsolutePath());
				}
				System.out.println(jfc.getSelectedFile().getName());
				
				storageRootPath = file.getAbsolutePath();
				rootTextField.setText(storageRootPath);
			}
		});
		panel.add(open);

		//选择文件目录
		
		JButton btnInstallService = new JButton("安装服务");
		btnInstallService.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (storageRootPath == null) {
					JOptionPane.showMessageDialog(null, "工作目录不能为空", "标题",JOptionPane.WARNING_MESSAGE);  
				}
				else {
					String path = System.getProperty("user.dir");
					System.out.println("安装obpm-gateway");
					try {
						//生成配置文件
						generateWinswConf("obpm-gateway", siteId, null, "-Xms64M -Xmx128M -XX:PermSize=32M -XX:MaxPermSize=64M");
						generateWinswConf("obpm-signon", siteId , storageRootPath, "-Xms64M -Xmx128M -XX:PermSize=32M -XX:MaxPermSize=64M");
						generateWinswConf("obpm-runtime", siteId, storageRootPath, "-Xms128M -Xmx384M -XX:PermSize=64M -XX:MaxPermSize=128M");
						generateWinswConf("obpm-kms", siteId, storageRootPath, "-Xms64M -Xmx128M -XX:PermSize=32M -XX:MaxPermSize=64M");
						generateWinswConf("obpm-designer", siteId, storageRootPath, "-Xms64M -Xmx256M -XX:PermSize=32M -XX:MaxPermSize=96M");
						
						//运行
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-gateway.exe","install"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-signon.exe","install"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-runtime.exe","install"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-kms.exe","install"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-designer.exe","install"});
						
					} catch (Exception e1) {
						e1.printStackTrace();
					}
				}
				
			}
		});

		panel.add(btnInstallService);
		
		//启动服务
		JButton btnStartService = new JButton("启动服务");
		btnStartService.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				String path = System.getProperty("user.dir");

					System.out.println("启动服务");
					try {
						//运行
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","start","obpm-gateway"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","start","obpm-signon"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","start","obpm-runtime"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","start","obpm-kms"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","start","obpm-designer"});
					} catch (Exception e1) {
						e1.printStackTrace();
					}
			}
		});
		panel.add(btnStartService);

		
		//卸载服务

		JButton btnRemoveService = new JButton("卸载服务");
		btnRemoveService.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				String path = System.getProperty("user.dir");
					System.out.println("卸载服务");
					try {
						//停止
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","stop","obpm-gateway"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","stop","obpm-signon"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","stop","obpm-runtime"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","stop","obpm-kms"});
						exec(new String[]{ path + "\\nircmd.exe","elevate","net","stop","obpm-designer"});

						//卸载
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-gateway.exe","uninstall"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-signon.exe","uninstall"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-runtime.exe","uninstall"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-kms.exe","uninstall"});
						exec(new String[]{path + "\\nircmd.exe","elevate",path + "\\obpm-designer.exe","uninstall"});
					
					} catch (Exception e1) {
						e1.printStackTrace();
					}
			}
		});
		
		panel.add(btnRemoveService);
		
		//说明
		JTextPane textPan = new JTextPane();
		textPan.setSize(400, 100);
		textPan.setEditable(false);
		textPan.setText("说明:\r\n"
				+ "工作目录为模板、上传、配置等文件的存放目录\r\n"
				+ "工作目录运行前必须指定，服务安装后不能更改。\r\n"
				+ "安装时提示管理员权限，必须选择同意，否则安装不成功!\r\n"
				+ "杀毒软件360等会提示安全问题，必须选择信任，否则安装不成功！");
		panel.add(textPan);

		
		frame.add(panel);
		frame.setBounds(300, 200, 450, 300);
		frame.setVisible(true);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] agrs) {
		new InstallerServiceWizad(); // 创建一个实例化对象
	}
}
