package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication
//@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
//@SpringBootApplication
@EnableFeignClients(basePackages = "cn.myapps.conf")
@ComponentScan(basePackages = {"cn.myapps.run","cn.myapps.conf", "cn.myapps.common.util",
		// "cn.myapps.runtime.rest.security.service",
		//"cn.myapps.util",
		//"cn.myapps.base.web",
		//"cn.myapps.runtime.common.utils",
		"cn.myapps.message",
		"cn.myapps.**.message.controller",
		"cn.myapps.message.notice.service",
		"cn.myapps.**.message.dao",
		"cn.myapps.message.**.dao",
		"cn.myapps.**.message.service",
		//"cn.myapps.**.action",
		//"com.teemlink.km",
		//"cn.myapps.common.exception",
		"cn.myapps.message.**.controller",
		"cn.myapps.message.**.service"
		//,
		//, "cn.myapps.designtime.report"
//		"cn.myapps.runtime.workflow.analyzer"
//		, "com.jgqz"
})
@EntityScan(basePackages= {"cn.myapps.message"})
@EnableJpaRepositories(basePackages= {"cn.myapps.message.**.dao"})
public class MessageWithWar extends SpringBootServletInitializer {

	public static void main(String[] args) {
		try{
			SpringApplication.run(MessageWithWar.class, args);
		}catch (Exception e){
			e.printStackTrace();
		}

	}


	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
		return builder.sources(MessageWithWar.class);
	}

}
