/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.services.impls;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.IdWorker;
import com.bcxin.Infrastructures.SystemConstant;
import com.bcxin.Infrastructures.TenantConfigProperty;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.exceptions.AccountLockedException;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.api.interfaces.commons.OperateLogRpcProvider;
import com.bcxin.api.interfaces.enums.UpdatePasswordType;
import com.bcxin.identity.domains.components.FaceIdentityForgetPasswordExecutorImpl;
import com.bcxin.identity.domains.components.ForgetPasswordExecutorImpl;
import com.bcxin.identity.domains.components.PasswordEncoder;
import com.bcxin.identity.domains.components.SmsForgetPasswordExecutor;
import com.bcxin.identity.domains.components.commands.ForgetPasswordActionExecuteCommand;
import com.bcxin.identity.domains.configs.EnvConfig;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.entities.PrincipalAbstract;
import com.bcxin.identity.domains.entities.ToCOAuthSubjectPrincipalEntity;
import com.bcxin.identity.domains.entities.UserNamePasswordPrincipalEntity;
import com.bcxin.identity.domains.entities.WechatPrincipalEntity;
import com.bcxin.identity.domains.enums.COAuthType;
import com.bcxin.identity.domains.enums.ForgetPasswordAction;
import com.bcxin.identity.domains.exceptions.IdentityExceptionConverter;
import com.bcxin.identity.domains.exceptions.IdentityNotFoundException;
import com.bcxin.identity.domains.readers.IdentityDbReader;
import com.bcxin.identity.domains.readers.dtos.UserReaderDto;
import com.bcxin.identity.domains.repositories.IdentityUserRepository;
import com.bcxin.identity.domains.repositories.ToCOAuthSubjectPrincipalRepository;
import com.bcxin.identity.domains.repositories.UserNamePasswordPrincipalRepository;
import com.bcxin.identity.domains.repositories.WechatPrincipalRepository;
import com.bcxin.identity.domains.repositories.dtos.IdentityUserNamePasswordDTO;
import com.bcxin.identity.domains.services.IdentityUserService;
import com.bcxin.identity.domains.services.commandResult.PrepareResetPasswordCommandResult;
import com.bcxin.identity.domains.services.commandResult.WechatCgiBinSignInCommandResult;
import com.bcxin.identity.domains.services.commands.ChangePasswordCommand;
import com.bcxin.identity.domains.services.commands.ChangeUserNameCommand;
import com.bcxin.identity.domains.services.commands.PrepareResetPasswordCommand;
import com.bcxin.identity.domains.services.commands.ResetPasswordCommand;
import com.bcxin.identity.domains.services.commands.ResetPasswordCommandAdmin;
import com.bcxin.identity.domains.services.commands.SignInCommand;
import com.bcxin.identity.domains.services.commands.SignUpCommand;
import com.bcxin.identity.domains.services.commands.TocUserAssignIdentityCommand;
import com.bcxin.identity.domains.services.commands.UpdateIdentityBasicCommand;
import com.bcxin.identity.domains.services.commands.WechatBindCommand;
import com.bcxin.identity.domains.services.commands.WechatCgiBinSignInCommand;
import com.bcxin.identity.domains.services.commands.WechatCheckUnionIdCommand;
import com.bcxin.identity.domains.services.commands.WechatSignInCommand;
import com.bcxin.identity.domains.services.commands.WechatUnBindCommand;
import com.bcxin.identity.domains.utils.JwtUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IdentityUserServiceImpl
implements IdentityUserService {
    private static final Logger log = LoggerFactory.getLogger(IdentityUserServiceImpl.class);
    private final IdentityUserRepository identityUserRepository;
    private final UserNamePasswordPrincipalRepository userNamePasswordPrincipalRepository;
    private final WechatPrincipalRepository wechatPrincipalRepository;
    private final PasswordEncoder passwordEncoder;
    private final UnitWork unitWork;
    private final IdentityDbReader dbReader;
    private final SmsForgetPasswordExecutor smsForgetPasswordExecutor;
    private final FaceIdentityForgetPasswordExecutorImpl faceIdentityForgetPasswordExecutor;
    private final TenantConfigProperty configProperty;
    private final JsonProvider jsonProvider;
    private final EnvConfig envConfig;
    private final OperateLogRpcProvider operateLogRpcProvider;
    private final ToCOAuthSubjectPrincipalRepository toCOAuthSubjectPrincipalRepository;
    private final IdWorker idWorker;

    public IdentityUserServiceImpl(IdentityUserRepository identityUserRepository, UserNamePasswordPrincipalRepository userNamePasswordPrincipalRepository, WechatPrincipalRepository wechatPrincipalRepository, PasswordEncoder passwordEncoder, UnitWork unitWork, IdentityDbReader dbReader, SmsForgetPasswordExecutor smsForgetPasswordExecutor, FaceIdentityForgetPasswordExecutorImpl faceIdentityForgetPasswordExecutor, TenantConfigProperty configProperty, JsonProvider jsonProvider, EnvConfig envConfig, OperateLogRpcProvider operateLogRpcProvider, ToCOAuthSubjectPrincipalRepository toCOAuthSubjectPrincipalRepository, IdWorker idWorker) {
        this.identityUserRepository = identityUserRepository;
        this.userNamePasswordPrincipalRepository = userNamePasswordPrincipalRepository;
        this.wechatPrincipalRepository = wechatPrincipalRepository;
        this.passwordEncoder = passwordEncoder;
        this.unitWork = unitWork;
        this.dbReader = dbReader;
        this.smsForgetPasswordExecutor = smsForgetPasswordExecutor;
        this.faceIdentityForgetPasswordExecutor = faceIdentityForgetPasswordExecutor;
        this.configProperty = configProperty;
        this.jsonProvider = jsonProvider;
        this.envConfig = envConfig;
        this.operateLogRpcProvider = operateLogRpcProvider;
        this.toCOAuthSubjectPrincipalRepository = toCOAuthSubjectPrincipalRepository;
        this.idWorker = idWorker;
    }

    @Override
    public SignInCommand.SignInCommandResult signIn(SignInCommand command) {
        IdentityUserNamePasswordDTO identityUserNamePasswordDTO = this.identityUserRepository.findOne(command.getUserName());
        if (identityUserNamePasswordDTO == null) {
            throw new BadTenantException("\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e!");
        }
        UserNamePasswordPrincipalEntity principal = this.userNamePasswordPrincipalRepository.getByUserName(command.getUserName());
        if (principal.isLock()) {
            throw new AccountLockedException(String.format("\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u5df2\u8fde\u7eed\u8f93\u95195\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u5b89\u5168\u9501\u5b9a\uff0c\u8bf7\u4e8e%s\u5206\u949f\u540e\u91cd\u65b0\u767b\u5f55\u3002", principal.getLockRemainingTime()));
        }
        if (command.isValidPassword() && !this.passwordEncoder.isMatched(identityUserNamePasswordDTO.getPassword(), command.getPassword())) {
            AtomicInteger count = new AtomicInteger();
            this.unitWork.executeTran(() -> {
                count.set(principal.loginFailAddCount());
                this.userNamePasswordPrincipalRepository.save(principal);
            });
            if (count.get() >= 5) {
                throw new AccountLockedException(String.format("\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u5df2\u8fde\u7eed\u8f93\u95195\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u5b89\u5168\u9501\u5b9a\uff0c\u8bf7\u4e8e%s\u5206\u949f\u540e\u91cd\u65b0\u767b\u5f55\u3002", principal.getLockRemainingTime()));
            }
            throw new BadTenantException("\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e!");
        }
        if (!StringUtils.hasLength((String)identityUserNamePasswordDTO.getTenantUserId())) {
            throw new BadTenantException("\u8d26\u53f7\u5f02\u5e38, \u627e\u4e0d\u5230\u79df\u6237\u4fe1\u606f, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        try {
            this.unitWork.executeTran(() -> {
                if (principal.getLoginFailCount() != null && principal.getLoginFailCount() > 0) {
                    principal.loginFailClearCount();
                }
                principal.recordLastLoginTime();
                this.userNamePasswordPrincipalRepository.save(principal);
            });
            this.operateLogRpcProvider.loginLog(identityUserNamePasswordDTO.getTenantUserId(), command.getUserName(), identityUserNamePasswordDTO.getName(), command.getIpAddress());
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u767b\u5f55\u5931\u8d25\u8ba1\u6570\u3001\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        UpdatePasswordType updatePasswordType = null;
        if (command.isValidPassword()) {
            updatePasswordType = principal.getUpdatePasswordType();
        }
        return SignInCommand.SignInCommandResult.create(identityUserNamePasswordDTO.getIdentityUserId(), identityUserNamePasswordDTO.getTenantUserId(), identityUserNamePasswordDTO.getName(), identityUserNamePasswordDTO.getIdNum(), command.isFromMobile(), updatePasswordType);
    }

    @Override
    public int loginFailAddCount(UserNamePasswordPrincipalEntity principal) {
        AtomicInteger count = new AtomicInteger();
        this.unitWork.executeTran(() -> {
            count.set(principal.loginFailAddCount());
            this.userNamePasswordPrincipalRepository.save(principal);
        });
        return count.get();
    }

    @Override
    public void loginFailClearCount(UserNamePasswordPrincipalEntity principal) {
        this.unitWork.executeTran(() -> {
            if (principal.getLoginFailCount() != null && principal.getLoginFailCount() > 0) {
                principal.loginFailClearCount();
            }
            principal.recordLastLoginTime();
            this.userNamePasswordPrincipalRepository.save(principal);
        });
    }

    @Override
    public ChangePasswordCommand.ChangePasswordCommandResult changePassword(ChangePasswordCommand command) {
        IdentityUserEntity identityUser = this.identityUserRepository.getByUserName(command.getIdentityUserId(), command.getUserName());
        if (identityUser == null) {
            throw new IdentityNotFoundException();
        }
        this.unitWork.executeTran(() -> {
            identityUser.changePassword(command.getUserName(), this.passwordEncoder, command.getPassword(), command.getNewPassword(), command.getConfirmedPassword());
            this.identityUserRepository.save(identityUser);
        });
        return ChangePasswordCommand.ChangePasswordCommandResult.create(true);
    }

    @Override
    public void signUp(SignUpCommand command) {
        try {
            String username;
            IdentityUserEntity identityUser = IdentityUserEntity.create(command.getTenantUserId(), command.getName(), command.getTelephone(), command.getIdNum());
            String password = command.getIdNum();
            String string = username = this.envConfig.isRequiredPhoneAsLoginName() ? command.getTelephone() : command.getIdNum();
            if (this.envConfig.isRequiredPhoneAsLoginName()) {
                password = "123456";
            } else {
                if (command.getIdNum().length() > 6) {
                    password = command.getIdNum().substring(command.getIdNum().length() - 6);
                }
                if (!StringUtils.isEmpty((Object)this.envConfig.getPassPrefix())) {
                    password = this.envConfig.getPassPrefix() + password;
                }
            }
            identityUser.addUsernamePasswordPrincipal(username, password, this.passwordEncoder);
            identityUser.changeNote(this.jsonProvider.getJson((Object)command));
            this.unitWork.executeTran(() -> this.identityUserRepository.save(identityUser));
        }
        catch (Exception ex) {
            this.unitWork.detachAll();
            TenantExceptionAbstract tenantException = IdentityExceptionConverter.cast(ex);
            if (tenantException instanceof ConflictTenantException) {
                log.error("\u9884\u671f-\u53ef\u5ffd\u7565\u7684\u5f02\u5e38: \u7528\u6237(%s)\u5df2\u7ecf\u5b58\u5728!", (Object)command.getIdNum(), (Object)ex);
            }
            throw ex;
        }
    }

    @Override
    public void dispatch(WechatBindCommand command) {
        command.validate();
        IdentityUserEntity identityUserEntity = this.identityUserRepository.findByTenantUserId(command.getTenantId()).stream().findFirst().orElse(null);
        if (identityUserEntity == null) {
            throw new NotFoundTenantException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        WechatPrincipalEntity wechatPrincipalEntity = this.identityUserRepository.findByOpenId(command.getOpenId());
        if (wechatPrincipalEntity != null && !wechatPrincipalEntity.getIdentityUser().getTenantUserId().equals(command.getTenantId())) {
            throw new NotFoundTenantException("\u5f53\u524d\u5fae\u4fe1\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u7528\u6237\u4e86\uff0c\u4e0d\u80fd\u518d\u6b21\u7ed1\u5b9a\uff0c\u5982\u679c\u9700\u8981\u66f4\u6362\u7528\u6237\uff0c\u8bf7\u5148\u89e3\u7ed1\u65e7\u7528\u6237");
        }
        this.unitWork.executeTran(() -> {
            identityUserEntity.bindWechat(this.jsonProvider, command.getOpenId(), command.getNicky(), command.getUnionId());
            this.identityUserRepository.save(identityUserEntity);
            Collection<ToCOAuthSubjectPrincipalEntity> toCOAuthSubjectPrincipals = this.toCOAuthSubjectPrincipalRepository.findSubjectsByUnionId(COAuthType.WechatCgi, command.getUnionId());
            if (toCOAuthSubjectPrincipals != null) {
                Collection unBindCOAuthSubjectPrincipals = toCOAuthSubjectPrincipals.stream().filter(ii -> SystemConstant.isEmpty((String)ii.getTenantUserId())).collect(Collectors.toList());
                for (ToCOAuthSubjectPrincipalEntity toCOAuthSubjectPrincipal : unBindCOAuthSubjectPrincipals) {
                    toCOAuthSubjectPrincipal.assignAssign(identityUserEntity.getTenantUserId(), identityUserEntity.getId());
                    this.toCOAuthSubjectPrincipalRepository.save(toCOAuthSubjectPrincipal);
                    log.error("\u7ed1\u5b9a\u5fae\u4fe1\u7684\u65f6\u5019\u540c\u65f6\u7ed1\u5b9a\u4e86C\u7aef\u767b\u5165\u7528\u6237\u7684\u4e2a\u4eba\u4fe1\u606f:{}", (Object)toCOAuthSubjectPrincipal.getId(), (Object)toCOAuthSubjectPrincipal.getUnionId());
                }
            }
        });
    }

    @Override
    public SignInCommand.SignInCommandResult dispatch(WechatSignInCommand command) {
        command.validate();
        WechatPrincipalEntity wechatPrincipalEntity = this.identityUserRepository.findByOpenId(command.getOpenId());
        if (wechatPrincipalEntity == null) {
            throw new NotFoundTenantException("\u8d26\u53f7\u65e0\u6548");
        }
        IdentityUserEntity identityUser = wechatPrincipalEntity.getIdentityUser();
        try {
            this.unitWork.executeTran(() -> {
                wechatPrincipalEntity.recordLastLoginTime();
                this.wechatPrincipalRepository.save(wechatPrincipalEntity);
            });
            this.operateLogRpcProvider.loginLog(identityUser.getTenantUserId(), command.getOpenId(), identityUser.getName(), command.getIpAddress());
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return SignInCommand.SignInCommandResult.create(identityUser.getId(), identityUser.getTenantUserId(), identityUser.getName(), identityUser.getIdNum(), true, null);
    }

    @Override
    public void dispatch(UpdateIdentityBasicCommand command) {
        command.validate();
        IdentityUserEntity identityUser = this.identityUserRepository.findByTenantUserId(command.getTenantUserId()).stream().findFirst().orElse(null);
        if (identityUser == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        identityUser.change(command.getName(), command.getTelephone(), command.getIdNum(), this.envConfig.isRequiredPhoneAsLoginName());
        this.unitWork.executeTran(() -> this.identityUserRepository.save(identityUser));
    }

    @Override
    public void dispatch(WechatUnBindCommand command) {
        IdentityUserEntity identityUser = this.identityUserRepository.findByTenantUserId(command.getId()).stream().findFirst().orElse(null);
        if (identityUser == null) {
            throw new NotFoundTenantException("\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e!");
        }
        this.unitWork.executeTran(() -> {
            identityUser.unbindWechat();
            this.identityUserRepository.save(identityUser);
        });
    }

    @Override
    public boolean dispatch(WechatCheckUnionIdCommand command) {
        IdentityUserEntity identityUser = this.identityUserRepository.findByTenantUserId(command.getId()).stream().findFirst().orElse(null);
        if (identityUser == null) {
            return false;
        }
        if (identityUser.getPrincipals() == null || identityUser.getPrincipals().size() == 0) {
            return false;
        }
        Optional<PrincipalAbstract> principalOptional = identityUser.getPrincipals().stream().filter(ii -> ((Object)ii).getClass().isAssignableFrom(WechatPrincipalEntity.class)).findFirst();
        if (!principalOptional.isPresent()) {
            return false;
        }
        WechatPrincipalEntity wechatPrincipalEntity = (WechatPrincipalEntity)principalOptional.get();
        return StringUtils.hasLength((String)wechatPrincipalEntity.getUnionId());
    }

    @Override
    public PrepareResetPasswordCommandResult dispatch(PrepareResetPasswordCommand command) {
        command.validate();
        UserReaderDto userReaderDto = this.dbReader.getByUserName(command.getLoginName());
        if (userReaderDto == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        String faceImage = userReaderDto.getHeadPhoto();
        if (StringUtils.isEmpty((Object)faceImage) && command.getAction().equals((Object)ForgetPasswordAction.FaceIdentity)) {
            throw new NotFoundTenantException("\u8be5\u7528\u6237\u672a\u4e0a\u4f20\u8eab\u4efd\u8bc1\u5934\u50cf\uff0c\u65e0\u6cd5\u4f7f\u7528\u4eba\u8138\u8ba4\u8bc1\u627e\u56de\u5bc6\u7801");
        }
        if (StringUtils.hasLength((String)faceImage) && !faceImage.startsWith("http")) {
            faceImage = String.format("%s%s", this.configProperty.getSite(), faceImage);
        }
        return this.getByMessageType(command.getAction()).execute(ForgetPasswordActionExecuteCommand.create(userReaderDto.getStatus(), command.getLoginName(), userReaderDto.getTelephone(), userReaderDto.getName(), faceImage, command.getData()));
    }

    @Override
    public PrepareResetPasswordCommandResult getUserMobile(PrepareResetPasswordCommand command) {
        UserReaderDto userReaderDto = this.dbReader.getByUserName(command.getLoginName());
        if (userReaderDto == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        return PrepareResetPasswordCommandResult.create(null, true, null, userReaderDto.getTelephone(), StrUtil.isNotEmpty((CharSequence)userReaderDto.getHeadPhoto()));
    }

    @Override
    public void dispatch(ResetPasswordCommandAdmin command) {
        IdentityUserEntity identityUser = this.identityUserRepository.getDirectlyByUserName(command.getLoginName());
        if (identityUser == null) {
            throw new IdentityNotFoundException();
        }
        if (!StringUtils.hasLength((String)command.getNewPassword())) {
            String password = command.getLoginName();
            if (password.length() > 6) {
                password = command.getLoginName().substring(command.getLoginName().length() - 6);
            }
            if (!StringUtils.isEmpty((Object)this.envConfig.getPassPrefix())) {
                password = this.envConfig.getPassPrefix() + password;
            }
            command.setNewPassword(password);
        }
        this.unitWork.executeTran(() -> {
            identityUser.resetPassword(command.getLoginName(), this.passwordEncoder, command.getNewPassword(), command.getNewPassword(), true);
            this.identityUserRepository.save(identityUser);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resetPasswordCheckCode(ResetPasswordCommand command) {
        command.validate();
        String json = JwtUtil.parseJwt(command.getJwt());
        Map map = (Map)JSON.parse((String)json);
        String time = (String)map.get("time");
        String GetPasswordType = (String)map.get("GetPasswordType");
        String lName = (String)map.get("loginName");
        String sendCode = (String)map.get("code");
        boolean flg = IdentityUserServiceImpl.compareDate(time + "");
        if (!lName.equals(command.getLoginName())) {
            throw new BadTenantException("\u767b\u5f55\u8d26\u53f7\u8ba4\u8bc1\u51fa\u9519\u8bf7\u68c0\u67e5");
        }
        if (!flg) throw new BadTenantException("token\u8d85\u65f6,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        if (!"1".equals(GetPasswordType)) throw new BadTenantException("\u975e\u77ed\u4fe1\u627e\u56de\u5bc6\u7801\uff0c\u65e0\u6cd5\u6821\u9a8c\u9a8c\u8bc1\u7801\uff01");
        if (StringUtils.hasLength((String)command.getCode()) && command.getCode().equals(sendCode)) return;
        throw new BadTenantException("\u77ed\u4fe1\u9a8c\u8bc1,\u9a8c\u8bc1\u7801\u51fa\u9519");
    }

    @Override
    public WechatCgiBinSignInCommandResult dispatch(WechatCgiBinSignInCommand command) {
        ToCOAuthSubjectPrincipalEntity principal = this.toCOAuthSubjectPrincipalRepository.getByUnionIdAndOpenId(COAuthType.WechatCgi, command.getUnionId(), command.getOpenId());
        if (principal == null) {
            IdentityUserEntity identityUser = this.identityUserRepository.findIdentityUserByUnionId(command.getUnionId());
            ToCOAuthSubjectPrincipalEntity finalPrincipal = principal = ToCOAuthSubjectPrincipalEntity.create(COAuthType.WechatCgi, String.valueOf(this.idWorker.nextId()), command.getOpenId(), command.getUnionId(), command.getNicky(), command.getSysCode(), identityUser);
            this.unitWork.executeTran(() -> this.toCOAuthSubjectPrincipalRepository.save(finalPrincipal));
        }
        return WechatCgiBinSignInCommandResult.create(principal.getOpenId(), principal.getUnionId(), principal.getIdentityUserId(), principal.getTenantUserId(), principal.getNicky());
    }

    @Override
    public void dispatch(TocUserAssignIdentityCommand command) {
        ToCOAuthSubjectPrincipalEntity subjectPrincipal = this.toCOAuthSubjectPrincipalRepository.getByUnionIdAndOpenId(COAuthType.WechatCgi, command.getUnionId(), command.getOpenId());
        if (subjectPrincipal == null) {
            throw new NotFoundTenantException();
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            Collection<IdentityUserEntity> identityUsers = this.identityUserRepository.findByTenantUserId(command.getTenantUserId());
            IdentityUserEntity identityUser = identityUsers.stream().findFirst().orElse(null);
            if (identityUser == null) {
                identityUser = IdentityUserEntity.create(command.getTenantUserId(), command.getName(), command.getPhone(), command.getTenantUserId());
                this.identityUserRepository.save(identityUser);
            } else if (identityUsers.stream().count() > 1L) {
                log.error("TocUserAssignIdentityCommand: \u5f53\u524d\u627e\u5230\u7684\u7528\u6237\u4fe1\u606f:{};count={}", (Object)command.getTenantUserId(), (Object)identityUsers.stream().count());
            }
            subjectPrincipal.assignAssign(identityUser.getTenantUserId(), identityUser.getId());
            this.toCOAuthSubjectPrincipalRepository.save(subjectPrincipal);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw new BadTenantException(String.format("\u5173\u8054\u7528\u6237\u5f02\u5e38:%s", ex.getMessage()), ex);
        }
    }

    @Override
    public void dispatch(ChangeUserNameCommand command) {
        IdentityUserEntity identityUser = this.identityUserRepository.getByTenantUserId(command.getTenantUserId());
        if (identityUser == null) {
            throw new NotFoundTenantException();
        }
        this.unitWork.executeTran(() -> {
            identityUser.changeUserName(command.getUserName(), this.passwordEncoder, command.getPassword());
            this.identityUserRepository.save(identityUser);
            this.identityUserRepository.save(identityUser);
        });
    }

    @Override
    public void dispatch(ResetPasswordCommand command) {
        command.validate();
        IdentityUserEntity identityUser = this.identityUserRepository.getDirectlyByUserName(command.getLoginName());
        if (identityUser == null) {
            throw new IdentityNotFoundException();
        }
        String json = JwtUtil.parseJwt(command.getJwt());
        if (!StringUtils.hasLength((String)json)) {
            throw new ArgumentTenantException(String.format("\u53c2\u6570\u89e3\u6790\u5f02\u5e38:%s", command.getJwt()));
        }
        Map map = (Map)JSON.parse((String)json);
        String time = (String)map.get("time");
        String GetPasswordType = (String)map.get("GetPasswordType");
        String lName = (String)map.get("loginName");
        String sendCode = (String)map.get("code");
        boolean flg = IdentityUserServiceImpl.compareDate(time + "");
        if (!lName.equals(command.getLoginName())) {
            throw new BadTenantException("\u767b\u5f55\u8d26\u53f7\u8ba4\u8bc1\u51fa\u9519\u8bf7\u68c0\u67e5");
        }
        if (flg) {
            if ("1".equals(GetPasswordType)) {
                this.unitWork.executeTran(() -> {
                    identityUser.resetPassword(command.getLoginName(), this.passwordEncoder, command.getNewPassword(), command.getNewPassword(), false);
                    this.identityUserRepository.save(identityUser);
                });
            } else if ("0".equals(GetPasswordType)) {
                this.unitWork.executeTran(() -> {
                    identityUser.resetPassword(command.getLoginName(), this.passwordEncoder, command.getNewPassword(), command.getNewPassword(), false);
                    this.identityUserRepository.save(identityUser);
                });
            }
        } else {
            throw new BadTenantException("token\u8d85\u65f6,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
    }

    public static boolean compareDate(String time) {
        Calendar dateOne = Calendar.getInstance();
        Calendar dateTwo = Calendar.getInstance();
        dateOne.setTime(new Date());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        dateTwo.setTime(date);
        long timeOne = dateOne.getTimeInMillis();
        long timeTwo = dateTwo.getTimeInMillis();
        long minute = (timeOne - timeTwo) / 60000L;
        return minute <= 3L;
    }

    private ForgetPasswordExecutorImpl getByMessageType(ForgetPasswordAction action) {
        if (this == null) {
            throw new BadTenantException("\u5fd8\u8bb0\u5bc6\u7801\u7684\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (action) {
            case SMS: {
                return this.smsForgetPasswordExecutor;
            }
            case FaceIdentity: {
                return this.faceIdentityForgetPasswordExecutor;
            }
        }
        throw new NotSupportTenantException("\u4e0d\u652f\u6301\u8be5\u5fd8\u8bb0\u5bc6\u7801\u7684\u5b9e\u73b0\u65b9\u6848");
    }
}

