/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.Infrastructures.enums.AppealStatus;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.enums.UserType;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.api.interfaces.tenants.responses.TenantUserExtensionResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApiModel(description="\u5f53\u524d\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f")
public class UserProfileGetResponse
extends ResponseAbstract {
    @ApiModelProperty(value="Id")
    private final String id;
    @ApiModelProperty(value="\u59d3\u540d", required=true, example="\u5f20\u4e09")
    private final String name;
    @ApiModelProperty(value="\u7ecf\u7eac\u5ea6\u5750\u6807", example="'{\"latitude\":24.607463,\"longitude\":118.052021,\"time\":\"2021-07-14 11:24:04\"}'", dataType="String")
    private final String lonLatJson;
    @ApiModelProperty(value="\u624b\u673a\u53f7\u7801", dataType="String")
    private final String telephone;
    @ApiModelProperty(value="\u6838\u9a8c\u72b6\u6001", example="Matched", allowableValues="None, Matched, NotMatched.")
    private final UserCheckedStatus checkedStatus;
    @ApiModelProperty(value="\u5b9e\u540d\u8ba4\u8bc1\u72b6\u6001", example="Passed", allowableValues="UnAuthenticated, Authenticating, Failed, Passed.")
    private final RealNameAuthenticatedStatus authenticateStatus;
    @ApiModelProperty(value="\u5b9e\u540d\u8ba4\u8bc1\u65f6\u95f4")
    private final String authenticatedTime;
    @ApiModelProperty(value="\u5b9e\u540d\u8ba4\u8bc1\u5907\u6ce8", example="\u5b9e\u540d\u8ba4\u8bc1\u7ed3\u679c\u4e00\u81f4\u901a\u8fc7")
    private final String authenticatedResult;
    @ApiModelProperty(value="\u5934\u50cf")
    private final String headPhoto;
    @ApiModelProperty(value="\u6635\u79f0")
    private final String nicky;
    @ApiModelProperty(value="\u662f\u5426\u53ef\u4ee5\u4fee\u6539\u6635\u79f0\u3001\u5934\u50cf")
    private Boolean updateNicknameHeadPhoto = false;
    @ApiModelProperty(value="\u73af\u5883\u533a\u57df\u7f16\u7801")
    private String envRegionCode;
    @ApiModelProperty(value="\u6027\u522b")
    private final Sex sex;
    @ApiModelProperty(value="\u6c11\u65cf")
    private final String nation;
    @ApiModelProperty(value="\u75be\u75c5\u5386\u53f2")
    private final String diseasesHistory;
    @ApiModelProperty(value="\u4ece\u4e1a\u5e74\u9650")
    private final Integer workYear;
    @ApiModelProperty(value="\u653f\u6cbb\u9762\u8c8c")
    private final String politicsStatus;
    @ApiModelProperty(value="\u8eab\u9ad8", example="180cm")
    private final String stature;
    @ApiModelProperty(value="\u5175\u5f79\u60c5\u51b5")
    private final String militaryStatus;
    @ApiModelProperty(value="\u51fa\u751f\u65e5\u671f", example="1990-01-01", dataType="String")
    private final Date birthdate;
    @ApiModelProperty(value="\u6587\u5316\u7a0b\u5ea6")
    private final String education;
    @ApiModelProperty(value="\u6237\u7c4d\u7c7b\u578b")
    private final String householdType;
    @ApiModelProperty(value="\u7c4d\u8d2f")
    private final String nativePlace;
    @ApiModelProperty(value="\u5a5a\u59fb\u72b6\u51b5")
    private final String maritalStatus;
    @ApiModelProperty(value="\u4e00\u5bf8\u514d\u51a0\u767d\u5e95\u5f69\u7167")
    private final String oneInchColorWhitePhoto;
    @ApiModelProperty(value="\u4e24\u5bf8\u514d\u51a0\u84dd\u5e95\u5f69\u7167")
    private final String twoInchColorBluePhoto;
    @ApiModelProperty(value="\u8bbe\u5907Id")
    private final String cid;
    @ApiModelProperty(value="IM\u6807\u8bc6\u7b26")
    private String imIdentity;
    @ApiModelProperty(value="\u7d27\u6025\u8054\u7cfb\u4eba")
    private final String emergencyContact;
    @ApiModelProperty(value="\u7d27\u6025\u8054\u7cfb\u4eba\u7535\u8bdd")
    private final String emergencyPhone;
    @ApiModelProperty(value="\u9a7e\u7167\u7b49\u7ea7")
    private final String licenseLevel;
    @ApiModelProperty(value="\u73b0\u4f4f\u5730\u5740")
    private final LocationRequest placeOfNow;
    @ApiModelProperty(value="\u73b0\u4f4f\u5730\u5740")
    private final String thirdPartyLoginNo;
    @ApiModelProperty(value="\u7533\u8bc9\u72b6\u6001", example="None", allowableValues="None, Passed, Failed, Request.")
    private final AppealStatus appealStatus;
    @ApiModelProperty(value="\u6700\u540e\u4e00\u6b21\u7533\u8bc9\u7ed3\u679c")
    private final String lastAppealResult;
    @ApiModelProperty(value="\u6700\u540e\u4e00\u6b21\u7533\u8bc9\u65f6\u95f4")
    private final Date lastAppealTime;
    @ApiModelProperty(value="\u7528\u6237\u62d3\u5c55\u4fe1\u606f\u5217\u8868")
    private final List<TenantUserExtensionResponse> extensionList;
    @ApiModelProperty(value="\u7528\u6237\u62d3\u5c55\u4fe1\u606f\u5bf9\u8c61")
    private final Map<String, String> extensionMap;

    public UserProfileGetResponse(String id, String name, String telephone, String lonLatJson, Date birthdate, UserCheckedStatus checkedStatus, RealNameAuthenticatedStatus authenticateStatus, Date authenticatedTime, String authenticatedResult, String stature, String headPhoto, String nicky, Sex sex, String nation, String diseasesHistory, Integer workYear, String politicsStatus, String militaryStatus, String education, String householdType, String nativePlace, String maritalStatus, String oneInchColorWhitePhoto, String twoInchColorBluePhoto, String cid, String emergencyContact, String emergencyPhone, String licenseLevel, String thirdPartyLoginNo, String imIdentity, LocationRequest placeOfNow, AppealStatus appealStatus, String lastAppealResult, Date lastAppealTime, List<TenantUserExtensionResponse> extensionList) {
        this.id = id;
        this.name = name;
        this.lonLatJson = lonLatJson;
        this.telephone = telephone;
        this.birthdate = birthdate;
        this.checkedStatus = checkedStatus;
        this.authenticateStatus = authenticateStatus;
        if (authenticatedTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.authenticatedTime = dateFormat.format(authenticatedTime);
        } else {
            this.authenticatedTime = null;
        }
        this.authenticatedResult = authenticatedResult;
        this.stature = stature;
        this.headPhoto = CdnUtils.convert((String)headPhoto);
        this.nicky = nicky;
        this.appealStatus = appealStatus;
        this.lastAppealResult = lastAppealResult;
        this.lastAppealTime = lastAppealTime;
        this.sex = sex != null && (sex.ordinal() == Sex.Male.ordinal() || sex.ordinal() == Sex.Female.ordinal()) ? sex : null;
        this.nation = nation;
        this.diseasesHistory = diseasesHistory;
        this.workYear = workYear;
        this.politicsStatus = politicsStatus;
        this.militaryStatus = militaryStatus;
        this.education = education;
        this.householdType = householdType;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.oneInchColorWhitePhoto = CdnUtils.convert((String)oneInchColorWhitePhoto);
        this.twoInchColorBluePhoto = CdnUtils.convert((String)twoInchColorBluePhoto);
        this.cid = cid;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.placeOfNow = placeOfNow;
        this.thirdPartyLoginNo = thirdPartyLoginNo;
        this.imIdentity = imIdentity;
        this.extensionList = extensionList;
        this.extensionMap = new HashMap<String, String>();
        if (CollectionUtil.isNotEmpty(extensionList)) {
            for (TenantUserExtensionResponse extensionResponse : extensionList) {
                this.extensionMap.put(extensionResponse.getExtensionKey(), extensionResponse.getExtensionValue());
            }
        }
    }

    public static UserProfileGetResponse create(String id, String name, String telephone, String lonLatJson, Date birthdate, UserCheckedStatus checkedStatus, RealNameAuthenticatedStatus authenticateStatus, Date authenticatedTime, String authenticatedResult, String stature, UserType userType, String headPhoto, String nicky, Sex sex, String nation, String diseasesHistory, Integer workYear, String politicsStatus, String militaryStatus, String education, String householdType, String nativePlace, String maritalStatus, String oneInchColorWhitePhoto, String twoInchColorBluePhoto, String cid, String emergencyContact, String emergencyPhone, String licenseLevel, String thirdPartyLoginNo, String imIdentity, LocationRequest placeOfNow, AppealStatus appealStatus, String lastAppealResult, Date lastAppealTime, List<TenantUserExtensionResponse> extensionList) {
        return new UserProfileGetResponse(id, name, telephone, lonLatJson, birthdate, checkedStatus, authenticateStatus, authenticatedTime, authenticatedResult, stature, headPhoto, nicky, sex, nation, diseasesHistory, workYear, politicsStatus, militaryStatus, education, householdType, nativePlace, maritalStatus, oneInchColorWhitePhoto, twoInchColorBluePhoto, cid, emergencyContact, emergencyPhone, licenseLevel, thirdPartyLoginNo, imIdentity, placeOfNow, appealStatus, lastAppealResult, lastAppealTime, extensionList);
    }

    public void setUpdateNicknameHeadPhoto(Boolean updateNicknameHeadPhoto) {
        this.updateNicknameHeadPhoto = updateNicknameHeadPhoto;
    }

    public void setEnvRegionCode(String envRegionCode) {
        this.envRegionCode = envRegionCode;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLonLatJson() {
        return this.lonLatJson;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public UserCheckedStatus getCheckedStatus() {
        return this.checkedStatus;
    }

    public RealNameAuthenticatedStatus getAuthenticateStatus() {
        return this.authenticateStatus;
    }

    public String getAuthenticatedTime() {
        return this.authenticatedTime;
    }

    public String getAuthenticatedResult() {
        return this.authenticatedResult;
    }

    public String getHeadPhoto() {
        return this.headPhoto;
    }

    public String getNicky() {
        return this.nicky;
    }

    public Boolean getUpdateNicknameHeadPhoto() {
        return this.updateNicknameHeadPhoto;
    }

    public String getEnvRegionCode() {
        return this.envRegionCode;
    }

    public Sex getSex() {
        return this.sex;
    }

    public String getNation() {
        return this.nation;
    }

    public String getDiseasesHistory() {
        return this.diseasesHistory;
    }

    public Integer getWorkYear() {
        return this.workYear;
    }

    public String getPoliticsStatus() {
        return this.politicsStatus;
    }

    public String getStature() {
        return this.stature;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public String getEducation() {
        return this.education;
    }

    public String getHouseholdType() {
        return this.householdType;
    }

    public String getNativePlace() {
        return this.nativePlace;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public String getOneInchColorWhitePhoto() {
        return this.oneInchColorWhitePhoto;
    }

    public String getTwoInchColorBluePhoto() {
        return this.twoInchColorBluePhoto;
    }

    public String getCid() {
        return this.cid;
    }

    public String getImIdentity() {
        return this.imIdentity;
    }

    public String getEmergencyContact() {
        return this.emergencyContact;
    }

    public String getEmergencyPhone() {
        return this.emergencyPhone;
    }

    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    public LocationRequest getPlaceOfNow() {
        return this.placeOfNow;
    }

    public String getThirdPartyLoginNo() {
        return this.thirdPartyLoginNo;
    }

    public AppealStatus getAppealStatus() {
        return this.appealStatus;
    }

    public String getLastAppealResult() {
        return this.lastAppealResult;
    }

    public Date getLastAppealTime() {
        return this.lastAppealTime;
    }

    public List<TenantUserExtensionResponse> getExtensionList() {
        return this.extensionList;
    }

    public Map<String, String> getExtensionMap() {
        return this.extensionMap;
    }
}

