/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.events.DepartmentCreatedEvent;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.services.TDepartmentService;
import com.bcxin.tenant.domain.v5.services.commands.SyncDepartmentCommand;
import org.springframework.stereotype.Component;

@Component
public class V5DepartmentCreatedEventHandler
extends DomainEventHandlerAbstract<DepartmentCreatedEvent> {
    private final TDepartmentService departmentService;
    private final DataDispatcher dataDispatcher;

    public V5DepartmentCreatedEventHandler(TDepartmentService departmentService, DataDispatcher dataDispatcher) {
        this.departmentService = departmentService;
        this.dataDispatcher = dataDispatcher;
    }

    protected void execute(DepartmentCreatedEvent event) {
        DepartmentEntity department = (DepartmentEntity)event.getData();
        String superior = null;
        if (department.getParent() != null) {
            superior = department.getParent().getId();
        }
        SyncDepartmentCommand command = SyncDepartmentCommand.create(department.getId(), department.getName(), superior, department.getOrganization().getId(), department.getLevel());
        this.departmentService.create(command);
    }
}

