/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialsEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.events.EmployeeAfterCreatedEvent;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.SyncUserCommand;
import java.util.Collections;
import org.springframework.stereotype.Component;

@Component
public class EmployeeAfterCreatedEvent_V5Handler
extends DomainEventHandlerAbstract<EmployeeAfterCreatedEvent> {
    private final TUserService userService;
    private final DataDispatcher dataDispatcher;

    public EmployeeAfterCreatedEvent_V5Handler(TUserService userService, DataDispatcher dataDispatcher) {
        this.userService = userService;
        this.dataDispatcher = dataDispatcher;
    }

    protected void execute(EmployeeAfterCreatedEvent event) {
        EmployeeEntity employee = (EmployeeEntity)event.getData();
        TenantUserEntity tenantUser = employee.getTenantUser();
        String departId = null;
        if (employee != null && employee.getDefaultDepartment() != null) {
            departId = employee.getDefaultDepartment().getId();
        }
        TenantUserCredentialsEntity userCredentialsEntity = tenantUser.getSelectedCredential();
        SyncUserCommand command = SyncUserCommand.create(employee.getId(), tenantUser.getName(), event.isUsePhone() ? tenantUser.getTelephone() : tenantUser.getSelectIdNum(), employee.getOrganization().getId(), employee.getMasterSlaveType(), Collections.singleton(departId), userCredentialsEntity == null ? CredentialType.IdCard : userCredentialsEntity.getCredentialType(), userCredentialsEntity == null ? "" : userCredentialsEntity.getNumber(), employee.getDomainAdmin(), tenantUser.getTelephone());
        this.userService.create(command);
    }
}

