/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.business.repositories.impls;

import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.domain.v5.business.dtos.AppPackageReadonlyDto;
import com.bcxin.tenant.domain.v5.business.repositories.SettingRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SettingRepositoryImpl
implements SettingRepository {
    private static final String QUERY_APP_PACKAGE_SQL_TEMPLATE = "SELECT id,(select GROUP_CONCAT(item_app_id SEPARATOR ';') from tlk_package_app_list where item_package_id=a.id GROUP BY item_package_id) as ITEM_OWN_APPS,ITEM_REGISTERADDRESS,ITEM_REGISTERADDRESSID,ITEM_BAOFFICETYPE FROM tlk_app_package a where ITEM_REGISTERADDRESS=? and ITEM_BAOFFICETYPE=?";
    private static final String QUERY_APP_PACKAGE_SQL_TEMPLATE_FOR_REGULATORY = "SELECT id,(select GROUP_CONCAT(item_app_id SEPARATOR ';') from tlk_package_app_list where item_package_id=a.id GROUP BY item_package_id) as ITEM_OWN_APPS,ITEM_REGISTERADDRESS,ITEM_REGISTERADDRESSID,ITEM_BAOFFICETYPE FROM tlk_app_package a where ITEM_REGISTERADDRESSID=? and ITEM_BAOFFICETYPE=?";
    private final CacheProvider cacheProvider;
    private final DataSource dataSource;

    public SettingRepositoryImpl(CacheProvider cacheProvider, @Qualifier(value="organizationAuthDataSource") DataSource dataSource) {
        this.cacheProvider = cacheProvider;
        this.dataSource = dataSource;
    }

    @Override
    public AppPackageReadonlyDto getBy(String province, String city, String superviseRegionCode, String institutionalCode) {
        AppPackageReadonlyDto data = null;
        try (Connection conn = this.dataSource.getConnection();){
            ResultSet resultSet = this.getProvinceAndCity(conn, province, city, superviseRegionCode, institutionalCode, true);
            boolean hasRow = resultSet.next();
            if (!hasRow) {
                resultSet = this.getProvinceAndCity(conn, province, city, superviseRegionCode, institutionalCode, false);
                hasRow = resultSet.next();
            }
            data = hasRow ? AppPackageReadonlyDto.create(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5)) : AppPackageReadonlyDto.create(null, "__gZxrYDgj8OpfztxSuUg;__xkeybkGaZa1SboC9GL1", null, null, institutionalCode);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new BadTenantException("\u83b7\u53d6\u5e94\u7528\u5305\u5f02\u5e38");
        }
        return data;
    }

    private ResultSet getProvinceAndCity(Connection conn, String province, String city, String superviseRegionCode, String institutionalCode, boolean isQueryCity) {
        StringBuilder sb = new StringBuilder();
        try {
            ResultSet resultSet;
            if (institutionalCode.equals("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8") || institutionalCode.equals("\u4fdd\u5b89\u57f9\u8bad\u673a\u6784") || institutionalCode.equals("\u81ea\u884c\u62db\u7528\u4fdd\u5b89\u5458\u5355\u4f4d") || institutionalCode.equals("\u793e\u533a\u8b66\u52a1\u56e2\u961f")) {
                PreparedStatement statement = conn.prepareStatement(QUERY_APP_PACKAGE_SQL_TEMPLATE_FOR_REGULATORY);
                sb.append(String.format("sql=%s;", QUERY_APP_PACKAGE_SQL_TEMPLATE_FOR_REGULATORY));
                if (isQueryCity) {
                    statement.setString(1, superviseRegionCode);
                    sb.append(String.format("superviseRegionCode=%s;", superviseRegionCode));
                } else {
                    statement.setString(1, superviseRegionCode.substring(0, 2).concat("0000"));
                    sb.append(String.format("superviseRegionCode=%s;", superviseRegionCode.substring(0, 2).concat("0000")));
                }
                sb.append(String.format("institutionalCode=%s;", institutionalCode));
                statement.setString(2, institutionalCode);
                resultSet = statement.executeQuery();
            } else {
                PreparedStatement statement = conn.prepareStatement(QUERY_APP_PACKAGE_SQL_TEMPLATE);
                sb.append(String.format("sql=%s;", QUERY_APP_PACKAGE_SQL_TEMPLATE));
                if (isQueryCity) {
                    statement.setString(1, String.format("%s%s", province, city));
                    sb.append(String.format("1=%s;", String.format("%s%s", province, city)));
                } else {
                    statement.setString(1, String.format("%s", province));
                    sb.append(String.format("1=%s;", String.format("%s", province)));
                }
                statement.setString(2, institutionalCode);
                sb.append(String.format("2=%s;", institutionalCode));
                resultSet = statement.executeQuery();
            }
            return resultSet;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            sb.append(ex.toString());
            throw new BadTenantException("\u83b7\u53d6\u5e94\u7528\u5305\u5f02\u5e38:" + sb.toString());
        }
    }
}

