/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructure.messages;

import com.bcxin.Infrastructure.messages.components.DistributedLockProviderImpl;
import com.bcxin.Infrastructure.messages.components.UniqueVerificationCodeGeneratorImpl;
import com.bcxin.Infrastructures.components.LockProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.components.UniqueVerificationCodeGenerator;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="spring.redis")
public class MessageConfig {
    private String host;
    private String port;
    private String password;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress(String.format("redis://%s:%s", this.getHost(), this.getPort()));
        singleServerConfig.setPassword(this.getPassword());
        singleServerConfig.setConnectionPoolSize(10000);
        singleServerConfig.setPingConnectionInterval(10000);
        RedissonClient redissonClient = Redisson.create((Config)config);
        return redissonClient;
    }

    @Bean
    public LockProvider lockProvider(RedissonClient redissonClient) {
        return new DistributedLockProviderImpl(redissonClient);
    }

    @Bean
    public RetryProvider retryProvider() {
        return new RetryProvider.RetryProviderImpl();
    }

    @Bean
    public UniqueVerificationCodeGenerator uniqueVerificationCodeGenerator(RedissonClient redissonClient, RetryProvider retryProvider) {
        return new UniqueVerificationCodeGeneratorImpl(redissonClient, retryProvider);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageConfig)) {
            return false;
        }
        MessageConfig other = (MessageConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "MessageConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", password=" + this.getPassword() + ")";
    }
}

