package com.bcxin.saas.domains.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;

@Data
public class DepartmentEntity implements IAggregate {

    private String id;

    private String code;

    private String name;

    private int totalMember;

    /**
     * 索引树, 提高检索速度
     */
    @Column(name = "index_tree", nullable = false, length = 2000)
    private String indexTree;

    private String organizationId;

    @Column(name = "parent_id", nullable = false)
    private String parentId;

    /**
     * 是否有效
     */
    public int status;


}






