package com.bcxin.saas.domains.dtos;

import com.bcxin.saas.core.models.CacheItemAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.util.Calendar;
import java.util.List;

@Getter
@Setter(AccessLevel.PRIVATE)
public class DomainRelationDTO extends CacheItemAbstract {
    private String domainId;
    private List<String> childDomainIds;

    public static DomainRelationDTO create(String domainId, List<String> childDomainIds) {
        DomainRelationDTO domainRelationDTO = new DomainRelationDTO();
        domainRelationDTO.setDomainId(domainId);
        domainRelationDTO.setChildDomainIds(childDomainIds);
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(Calendar.MINUTE, 5);
        domainRelationDTO.setExpiredTime(nowTime.getTime());

        return domainRelationDTO;
    }

    public boolean getIsSuperDomain() {
        return childDomainIds != null &&
                childDomainIds.stream().anyMatch(ii -> "*".equals(ii));
    }

    private DomainRelationDTO(){

    }

    public static DomainRelationDTO create(String domainId,
                                           List<String> childDomainIds,
                                           boolean isEnabled) {
        DomainRelationDTO relationDTO = new DomainRelationDTO();
        relationDTO.setDomainId(domainId);
        relationDTO.setChildDomainIds(childDomainIds);

        return relationDTO;
    }
}
