/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.RetryUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component
public class RedisDistributedCacheProviderImpl
implements DistributedCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedCacheProviderImpl.class);
    private final RedisTemplate redisTemplate;
    private final RedissonClient redissonClient;

    public RedisDistributedCacheProviderImpl(RedisTemplate redisTemplate, RedissonClient redissonClient) {
        this.redisTemplate = redisTemplate;
        this.redissonClient = redissonClient;
    }

    public <T> T get(String key) {
        try {
            Object data = this.redisTemplate.opsForValue().get((Object)key);
            if (data == null) {
                return null;
            }
            return (T)data;
        }
        catch (Exception ex) {
            log.error(String.format("\u4eceRedis\u83b7\u53d6(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
            return null;
        }
    }

    public <T> T get(String key, Supplier<T> callback, long expires) {
        T data = this.get(key);
        if (data != null) {
            return data;
        }
        if (callback == null) {
            throw new SaasBadException("\u65e0\u6548\u56de\u8c03\u51fd\u6570");
        }
        data = callback.get();
        this.put(key, data, expires);
        return data;
    }

    public <T> void put(String key, T data) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, data);
        }
        catch (Exception ex) {
            log.error(String.format("Redis\u5b58\u50a8(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
        }
    }

    public <T> void put(String key, T data, long expires) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, data, expires, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            log.error(String.format("Redis\u5b58\u50a8(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
        }
    }

    public <T> void putForSet(String key, Collection<T> data) {
        try {
            this.redisTemplate.delete((Object)key);
            SetOperations setOperations = this.redisTemplate.opsForSet();
            Object[] arrayD = data.toArray(new Object[data.size()]);
            setOperations.add((Object)key, arrayD);
        }
        catch (Exception ex) {
            log.error(String.format("Redis\u5b58\u50a8(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
        }
    }

    public <T> void putForSetWithExpired(String key, Collection<T> data, long expires) {
        try {
            this.redisTemplate.delete((Object)key);
            SetOperations setOperations = this.redisTemplate.opsForSet();
            Object[] arrayD = data.toArray(new Object[data.size()]);
            setOperations.add((Object)key, arrayD);
            this.redisTemplate.expire((Object)key, expires, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            log.error(String.format("Redis\u5b58\u50a8(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
        }
    }

    public <T> void addToSet(String key, T data) {
        try {
            SetOperations setOperations = this.redisTemplate.opsForSet();
            setOperations.add((Object)key, new Object[]{data});
        }
        catch (Exception ex) {
            log.error(String.format("Redis\u5b58\u50a8(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
        }
    }

    public long getSetSize(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public <T> Collection<T> getRandomFromSet(String key, int count) {
        List dt = this.redisTemplate.opsForSet().randomMembers((Object)key, (long)count);
        return dt;
    }

    public <T> Collection<T> getFromSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public <T> void removeFromSet(String key, T data) {
        try {
            SetOperations setOperations = this.redisTemplate.opsForSet();
            setOperations.remove((Object)key, new Object[]{data});
        }
        catch (Exception ex) {
            log.error(String.format("Redis\u5b58\u50a8(%s)\u4fe1\u606f\u5931\u8d25", key), (Throwable)ex);
        }
    }

    public void clear(String prefix) {
        RetryUtil.execute(() -> {
            Collection<String> keys = this.keys(prefix);
            this.redisTemplate.delete(keys);
            return null;
        });
    }

    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public Collection<String> keys(String prefix) {
        Set keys = this.redisTemplate.keys((Object)String.format("%s*", prefix));
        return keys;
    }

    public void remove(Collection<String> keys) {
        RetryUtil.execute(() -> {
            this.redisTemplate.delete(keys);
            return null;
        });
    }

    public <T> void batchPut(final Map<String, T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        final RedisSerializer keySerializer = this.redisTemplate.getKeySerializer();
        final RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
        RetryUtil.execute(() -> {
            this.redisTemplate.executePipelined(new RedisCallback<T>(){

                public T doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    data.keySet().parallelStream().forEach(key -> {
                        Object value = data.get(key);
                        if (value != null) {
                            redisConnection.set(keySerializer.serialize(key), valueSerializer.serialize(value));
                        } else {
                            redisConnection.del((byte[][])new byte[][]{keySerializer.serialize(key)});
                        }
                    });
                    return null;
                }
            });
            return null;
        }, (int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeByLock(String key, Runnable runnable) {
        RLock rLock = this.redissonClient.getLock(RedisDistributedCacheProviderImpl.getRedissonLockKey(key));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            rLock.lock();
            runnable.run();
        }
        finally {
            rLock.unlock();
        }
        stopWatch.stop();
        return true;
    }

    public boolean lock(String key, int expiredInSeconds) {
        RLock lock = this.redissonClient.getLock(RedisDistributedCacheProviderImpl.getRedissonLockKey(key));
        lock.lock((long)expiredInSeconds, TimeUnit.SECONDS);
        return true;
    }

    public void release(String key) {
        RLock lock = this.redissonClient.getLock(RedisDistributedCacheProviderImpl.getRedissonLockKey(key));
        lock.unlock();
    }

    private static String getRedissonLockKey(String key) {
        return String.format("com:redisson:lock:%s", key.toLowerCase());
    }
}

