/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.tenant.domain.dto.XlcpReportDto;
import com.bcxin.tenant.domain.entities.XlcpEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.XlcpRepository;
import com.bcxin.tenant.domain.services.XlcpService;
import com.bcxin.tenant.domain.services.commands.xlcp.CreateXlcpCommand;
import com.bcxin.tenant.domain.services.commands.xlcp.UpdateXlcpCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class XlcpServiceImpl
implements XlcpService {
    private final EntityManager entityManager;
    private final XlcpRepository xlcpRepository;
    private final EmployeeRepository employeeRepository;
    private final UnitWork unitWork;

    public XlcpServiceImpl(XlcpRepository xlcpRepository, EmployeeRepository employeeRepository, EntityManager entityManager, UnitWork unitWork) {
        this.xlcpRepository = xlcpRepository;
        this.employeeRepository = employeeRepository;
        this.entityManager = entityManager;
        this.unitWork = unitWork;
    }

    @Override
    public void dispatch(CreateXlcpCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            XlcpEntity xlcp = XlcpEntity.create(command.getSerialNumber(), command.getProjectName(), command.getOrganizationId(), command.getEmployeeId(), command.getName(), command.getNumber(), command.getFileUrl(), command.getSuggestion(), command.getContent(), command.getResult(), command.getResultRuleTip());
            xlcp.assignCreator(AuthUtil.getCurrentOperator());
            xlcp.assignModifier(AuthUtil.getCurrentOperator());
            this.xlcpRepository.save((EntityAbstract)xlcp);
        });
    }

    @Override
    public void dispatch(List<CreateXlcpCommand> requests) {
        this.unitWork.executeTran(() -> requests.stream().forEach(command -> {
            XlcpEntity xlcp = XlcpEntity.create(command.getSerialNumber(), command.getProjectName(), command.getOrganizationId(), command.getEmployeeId(), command.getName(), command.getNumber(), command.getFileUrl(), command.getSuggestion(), command.getContent(), command.getResult(), command.getResultRuleTip());
            xlcp.assignCreator(AuthUtil.getCurrentOperator());
            xlcp.assignModifier(AuthUtil.getCurrentOperator());
            this.xlcpRepository.save((EntityAbstract)xlcp);
        }));
    }

    @Override
    public void update(List<CreateXlcpCommand> requests) {
        for (CreateXlcpCommand request : requests) {
            Query query = this.entityManager.createNativeQuery(String.format("UPDATE tenant_xlcp SET file_url='%s' WHERE serial_number= '%s';", request.getFileUrl(), request.getSerialNumber()));
            int n = query.executeUpdate();
        }
    }

    @Override
    public void dispatch(UpdateXlcpCommand command) {
        command.validate();
        List<XlcpEntity> xlcpList = this.xlcpRepository.getByOrganIdAndEmployeeId(command.getOrganizationId(), command.getEmployeeId());
        if (xlcpList.size() == 0) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u6d4b\u8bc4\u4fe1\u606f");
        }
        XlcpEntity xlcp = xlcpList.get(0);
        this.unitWork.executeTran(() -> {
            xlcp.change(command.getFileUrl(), command.getSuggestion(), command.getContent());
            xlcp.assignModifier(AuthUtil.getCurrentOperator());
            this.xlcpRepository.save((EntityAbstract)xlcp);
        });
    }

    @Override
    public void dispatch(String id, String fileUrl) {
        Optional xlcpOptional = this.xlcpRepository.findById(id);
        if (!xlcpOptional.isPresent()) {
            throw new BadTenantException("\u6d4b\u8bc4\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        XlcpEntity xlcp = (XlcpEntity)((Object)xlcpOptional.get());
        this.unitWork.executeTran(() -> {
            xlcp.change(fileUrl, xlcp.getSuggestion(), xlcp.getContent());
            this.xlcpRepository.save((EntityAbstract)xlcp);
        });
    }

    @Override
    public int isWithinTheDeadline(String empId) {
        if (!StringUtils.hasLength((String)empId)) {
            throw new ArgumentTenantException("\u96c7\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<XlcpEntity> list1 = this.xlcpRepository.countWithinTheDeadlineOfEmployeeId(empId, (Date)DateUtil.offset((Date)new Date(), (DateField)DateField.MONTH, (int)-240));
        if (list1.isEmpty()) {
            return 1;
        }
        List<XlcpEntity> list = this.xlcpRepository.countWithinTheDeadlineOfEmployeeId(empId, (Date)DateUtil.offset((Date)new Date(), (DateField)DateField.MONTH, (int)-6));
        if (list.isEmpty()) {
            return 2;
        }
        return 3;
    }

    @Override
    public Collection<XlcpReportDto> findByEmployeeIdAndProjectName(String employeeId, String projectName) {
        if (!StringUtils.hasLength((String)employeeId)) {
            throw new ArgumentTenantException("\u96c7\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)projectName)) {
            throw new ArgumentTenantException("\u6d4b\u8bc4\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Collection<XlcpEntity> list = this.xlcpRepository.findByEmployeeIdAndProjectName(employeeId, projectName);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<XlcpReportDto> result = new ArrayList<XlcpReportDto>();
        int index = 1;
        for (XlcpEntity xlcpEntity : list) {
            result.add(XlcpReportDto.create(String.valueOf(index++), xlcpEntity.getProjectName(), DateUtil.formatDateTime((Date)xlcpEntity.getCreator().getCreatedTime()), xlcpEntity.getFileUrl()));
        }
        return result;
    }

    @Override
    public Collection<XlcpReportDto> findByThirdPath(int day) {
        if (day <= 0) {
            throw new ArgumentTenantException("\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Collection<XlcpEntity> list = this.xlcpRepository.findByTimeAndLikeName((Date)DateUtil.offset((Date)new Date(), (DateField)DateField.DAY_OF_MONTH, (int)(-day)), "%bjzgxl%");
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<XlcpReportDto> result = new ArrayList<XlcpReportDto>();
        for (XlcpEntity xlcpEntity : list) {
            result.add(XlcpReportDto.create(xlcpEntity.getId(), xlcpEntity.getProjectName(), DateUtil.formatDateTime((Date)xlcpEntity.getCreator().getCreatedTime()), xlcpEntity.getFileUrl()));
        }
        return result;
    }

    @Override
    public XlcpReportDto getByserialNumber(String serialNumber) {
        if (StringUtils.isEmpty((Object)serialNumber)) {
            throw new ArgumentTenantException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        XlcpEntity xlcpEntity = this.xlcpRepository.getBySerialNumber(serialNumber);
        if (xlcpEntity == null) {
            return null;
        }
        return XlcpReportDto.create(xlcpEntity.getId(), xlcpEntity.getProjectName(), DateUtil.formatDateTime((Date)xlcpEntity.getCreator().getCreatedTime()), xlcpEntity.getFileUrl());
    }
}

