/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.enums.AbnormalPersonnelEmployeeType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.tenant.domain.configs.SSOConfig;
import com.bcxin.tenant.domain.dto.SingleLoginUserDto;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.services.EmployeeService;
import com.bcxin.tenant.domain.services.NaturalSingleLoginService;
import com.bcxin.tenant.domain.services.commands.CreateEmployeeRequestCommand;
import com.bjtoon.uia.sdk.client.DefaultUiaClient;
import com.bjtoon.uia.sdk.domain.AccessTokenVo;
import com.bjtoon.uia.sdk.domain.UserInfoVo;
import com.bjtoon.uia.sdk.exception.UiaException;
import com.bjtoon.uia.sdk.request.UiaOauthAccessTokenRequest;
import com.bjtoon.uia.sdk.request.UiaOauthUserInfoRequest;
import com.bjtoon.uia.sdk.request.UiaRequest;
import com.bjtoon.uia.sdk.response.UiaOauthAccessTokenResponse;
import com.bjtoon.uia.sdk.response.UiaOauthUserInfoResponse;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NaturalSingleLoginServiceImpl
implements NaturalSingleLoginService {
    private final Logger logger = LoggerFactory.getLogger(NaturalSingleLoginServiceImpl.class);
    private final EmployeeRepository employeeRepository;
    private final EmployeeService employeeService;
    private final RedisUtil redisUtil;

    public NaturalSingleLoginServiceImpl(EmployeeRepository employeeRepository, EmployeeService employeeService, RedisUtil redisUtil) {
        this.employeeRepository = employeeRepository;
        this.employeeService = employeeService;
        this.redisUtil = redisUtil;
    }

    @Override
    public SingleLoginUserDto saveLoginUser(String code) {
        String token = this.getToken(code);
        if (StrUtil.isNotEmpty((CharSequence)token)) {
            UiaOauthUserInfoRequest uiaOauthUserInfoRequest;
            DefaultUiaClient uiaClient = new DefaultUiaClient(SSOConfig.getUrl());
            UiaOauthUserInfoResponse userInfoResponse = (UiaOauthUserInfoResponse)uiaClient.execute((UiaRequest)(uiaOauthUserInfoRequest = new UiaOauthUserInfoRequest("/api/info/getUserInfo", token, SSOConfig.getClientSecret())), true);
            if (null != userInfoResponse && userInfoResponse.isSuccess()) {
                UserInfoVo userInfoVo = userInfoResponse.getUserInfoVo();
                EmployeeEntity employee = this.employeeRepository.getByIdNum(SSOConfig.getDomainId(), userInfoVo.getCertNo());
                String employeeId = null;
                ArrayList<String> roles = null;
                if (employee == null) {
                    String password = null;
                    if (StrUtil.isNotEmpty((CharSequence)userInfoVo.getCertNo())) {
                        String certNo = userInfoVo.getCertNo();
                        password = StrUtil.isNotEmpty((CharSequence)SSOConfig.getPassPrefix()) ? SSOConfig.getPassPrefix() + certNo.substring(certNo.length() - 6, certNo.length()) : null;
                    }
                    employeeId = this.employeeService.dispatch(CreateEmployeeRequestCommand.create(SSOConfig.getDomainId(), userInfoVo.getCertName(), userInfoVo.getMobile(), password, SSOConfig.getDepartId(), OccupationType.Normal, null, new Date(), CredentialType.IdCard, userInfoVo.getCertNo(), AuthUtil.getCurrentOperator(), AbnormalPersonnelEmployeeType.NOT_VERIFY));
                    roles = new ArrayList<String>();
                    roles.add(SSOConfig.getRoleId());
                } else {
                    employeeId = employee.getId();
                }
                return SingleLoginUserDto.create(employeeId, userInfoVo.getCertNo(), roles);
            }
            if (null != userInfoResponse) {
                this.logger.error(JSON.toJSONString((Object)userInfoResponse));
            }
        }
        return null;
    }

    private String getToken(String code) {
        String token = null;
        if (this.redisUtil.get(code) != null) {
            token = this.redisUtil.get(code).toString();
        } else {
            DefaultUiaClient uiaClient = new DefaultUiaClient(SSOConfig.getUrl());
            try {
                UiaOauthAccessTokenRequest request = new UiaOauthAccessTokenRequest("/api/oauth/getAccessToken", SSOConfig.getClientId(), SSOConfig.getClientSecret(), code, "authorization_code", "user_info");
                UiaOauthAccessTokenResponse tokenResponse = (UiaOauthAccessTokenResponse)uiaClient.execute((UiaRequest)request);
                if (tokenResponse.isSuccess()) {
                    AccessTokenVo accessTokenVo = tokenResponse.getAccessTokenVo();
                    token = accessTokenVo.getAccess_token();
                    this.redisUtil.set(code, (Object)token, 86400L);
                } else {
                    this.logger.error(JSON.toJSONString((Object)tokenResponse));
                }
            }
            catch (UiaException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return token;
    }

    @Override
    public SingleLoginUserDto saveCommonLoginUser(String certName, String certNo, String mobile) {
        if (StrUtil.isNotEmpty((CharSequence)certNo)) {
            EmployeeEntity employee = this.employeeRepository.getByIdNum(SSOConfig.getDomainId(), certNo);
            String employeeId = null;
            ArrayList<String> roles = null;
            if (employee == null) {
                String password = StrUtil.isNotEmpty((CharSequence)SSOConfig.getPassPrefix()) ? SSOConfig.getPassPrefix() + certNo.substring(certNo.length() - 6, certNo.length()) : null;
                employeeId = this.employeeService.dispatch(CreateEmployeeRequestCommand.create(SSOConfig.getDomainId(), certName, mobile, password, SSOConfig.getDepartId(), OccupationType.Normal, null, new Date(), CredentialType.IdCard, certNo, AuthUtil.getCurrentOperator(), AbnormalPersonnelEmployeeType.NOT_VERIFY));
                roles = new ArrayList<String>();
                roles.add(SSOConfig.getRoleId());
            } else {
                employeeId = employee.getId();
            }
            return SingleLoginUserDto.create(employeeId, certNo, roles);
        }
        return null;
    }

    @Override
    public SingleLoginUserDto saveLegalLoginUser(String certName, String certNo, String mobile) {
        if (StrUtil.isNotEmpty((CharSequence)certNo)) {
            EmployeeEntity employee = this.employeeRepository.getByIdNum(SSOConfig.getDomainId(), certNo);
            ArrayList<String> roles = null;
            if (employee == null) {
                String password = StrUtil.isNotEmpty((CharSequence)SSOConfig.getPassPrefix()) ? SSOConfig.getPassPrefix() + certNo.substring(certNo.length() - 6, certNo.length()) : null;
                this.employeeService.dispatch(CreateEmployeeRequestCommand.create(SSOConfig.getDomainId(), certName, mobile, password, SSOConfig.getDepartId(), OccupationType.Normal, null, new Date(), CredentialType.IdCard, certNo, AuthUtil.getCurrentOperator(), AbnormalPersonnelEmployeeType.NOT_VERIFY));
                employee = this.employeeRepository.getByIdNum(SSOConfig.getDomainId(), certNo);
                roles = new ArrayList<String>();
                roles.add(SSOConfig.getLegalRoleId());
            }
            return SingleLoginUserDto.create(employee.getId(), certNo, roles);
        }
        return null;
    }
}

