/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.models.DataCacheItem;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.exceptions.UnexpectedTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.domain.conditions.TenantUserSameValidator;
import com.bcxin.tenant.domain.conditions.requests.TenantUserSameCheckRequest;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.ImportDataEntity;
import com.bcxin.tenant.domain.entities.ImportDataItemEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.enums.ImportedDataCategory;
import com.bcxin.tenant.domain.exceptions.EmployeeConflictException;
import com.bcxin.tenant.domain.exceptions.EntryEmployeeValidationException;
import com.bcxin.tenant.domain.exceptions.TenantExceptionConverter;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.ImportDataEntityRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.UniqueDataConstraintRepository;
import com.bcxin.tenant.domain.repositories.composites.EmployeeDepartWrapper;
import com.bcxin.tenant.domain.repositories.composites.EmployeeImportWrapper;
import com.bcxin.tenant.domain.services.ImportDataService;
import com.bcxin.tenant.domain.services.commands.BatchImportEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.results.ProcessImportDataCommandResult;
import com.bcxin.tenant.domain.snapshots.EmployeeImportedItemSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ImportDataServiceImpl
implements ImportDataService {
    private static final Logger log = LoggerFactory.getLogger(ImportDataServiceImpl.class);
    private final JsonProvider jsonProvider;
    private final DepartmentRepository departmentRepository;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final UnitWork unitWork;
    private final UniqueDataConstraintRepository uniqueDataConstraintRepository;
    private final EmployeeRepository employeeRepository;
    private final CacheProvider cacheProvider;
    private final ImportDataEntityRepository importDataEntityRepository;
    private final OrganizationRepository organizationRepository;
    private final EventDispatcher eventDispatcher;
    private final EnvConfig envConfig;
    private final TenantUserSameValidator tenantUserSameValidator;

    public ImportDataServiceImpl(JsonProvider jsonProvider, DepartmentRepository departmentRepository, ThreadPoolTaskExecutor taskExecutor, UnitWork unitWork, UniqueDataConstraintRepository uniqueDataConstraintRepository, EmployeeRepository employeeRepository, CacheProvider cacheProvider, ImportDataEntityRepository importDataEntityRepository, OrganizationRepository organizationRepository, EventDispatcher eventDispatcher, EnvConfig envConfig, TenantUserSameValidator tenantUserSameValidator) {
        this.jsonProvider = jsonProvider;
        this.departmentRepository = departmentRepository;
        this.taskExecutor = taskExecutor;
        this.unitWork = unitWork;
        this.uniqueDataConstraintRepository = uniqueDataConstraintRepository;
        this.employeeRepository = employeeRepository;
        this.cacheProvider = cacheProvider;
        this.importDataEntityRepository = importDataEntityRepository;
        this.organizationRepository = organizationRepository;
        this.eventDispatcher = eventDispatcher;
        this.envConfig = envConfig;
        this.tenantUserSameValidator = tenantUserSameValidator;
    }

    @Override
    public ProcessImportDataCommandResult waitForProcessing(String id, OperatorValueType operator, Set<String> treeCodes) {
        DataCacheItem employeeImportWrapperCache = (DataCacheItem)this.cacheProvider.get(id, () -> {
            Optional importDataOptional = this.importDataEntityRepository.findById(id);
            if (!importDataOptional.isPresent()) {
                return null;
            }
            Optional organizationOptional = this.organizationRepository.findById(((ImportDataEntity)((Object)((Object)importDataOptional.get()))).getOrganizationId());
            if (!organizationOptional.isPresent()) {
                return null;
            }
            EmployeeImportWrapper importWrapper = EmployeeImportWrapper.create((OrganizationEntity)((Object)((Object)organizationOptional.get())), (ImportDataEntity)((Object)((Object)importDataOptional.get())));
            return DataCacheItem.create((Object)importWrapper);
        });
        if (employeeImportWrapperCache == null || employeeImportWrapperCache.getData() == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5bfc\u5165\u6570\u636e");
        }
        OrganizationEntity organization = ((EmployeeImportWrapper)employeeImportWrapperCache.getData()).getOrganization();
        ImportDataEntity importData = ((EmployeeImportWrapper)employeeImportWrapperCache.getData()).getImportData();
        importData.setOperator(operator);
        if (importData.getCategory() == ImportedDataCategory.Employee) {
            this.processEmployee(organization, importData, treeCodes);
        }
        return ProcessImportDataCommandResult.create(importData.getId(), (int)importData.getDataItems().stream().count(), (int)importData.getDataItems().stream().filter(ii -> ii.getStatus() == ProcessedStatus.Done).count(), (int)importData.getDataItems().stream().filter(ii -> ii.getStatus() == ProcessedStatus.Error).count());
    }

    private void processEmployee(OrganizationEntity organization, ImportDataEntity importData, Set<String> treeCodes) {
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        if (currentUser == null) {
            throw new UnAuthorizedTenantException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        boolean isMaster = currentUser.isMaster();
        boolean isDepartAdmin = currentUser.isDepartAdmin();
        if (!isMaster && !isDepartAdmin) {
            throw new UnAuthorizedTenantException("\u53ea\u6709\u7ec4\u7ec7\u7ba1\u7406\u5458\u6216\u90e8\u95e8\u7ba1\u7406\u5458\u6709\u6743\u9650\u64cd\u4f5c");
        }
        Map<ImportDataItemEntity, BatchImportEmployeeCommand.EmployeeCommandItem> commandItemsMap = importData.getDataItems().stream().filter(ii -> ii.getStatus() == ProcessedStatus.Init).collect(Collectors.toMap(it -> it, ii -> {
            EmployeeImportedItemSnapshot itemSnapshot = (EmployeeImportedItemSnapshot)this.jsonProvider.toObject(EmployeeImportedItemSnapshot.class, ii.getData());
            return BatchImportEmployeeCommand.EmployeeCommandItem.create(itemSnapshot);
        }));
        Collection departNames = commandItemsMap.values().stream().map(ii -> {
            if (StringUtils.hasLength((String)ii.getDepartName())) {
                return ii.getDepartName();
            }
            return null;
        }).distinct().collect(Collectors.toList());
        Collection<DepartmentEntity> selectedDeparts = this.departmentRepository.getDepartAndRootByOrganIdName(importData.getOrganizationId(), departNames);
        HashMap<ImportDataItemEntity, EmployeeDepartWrapper> employeeDepartWrappersMap = new HashMap<ImportDataItemEntity, EmployeeDepartWrapper>();
        for (ImportDataItemEntity dataItem : commandItemsMap.keySet()) {
            Object commandItem = commandItemsMap.get((Object)dataItem);
            DepartmentEntity departmentEntity = commandItem.validateDepartTree(selectedDeparts);
            if (departmentEntity != null) {
                if (!isMaster && treeCodes.stream().noneMatch(code -> selectedDepart.getIndexTree().startsWith((String)code))) {
                    dataItem.changeStatus(ProcessedStatus.Error, "\u60a8\u65e0\u5f53\u524d\u5bfc\u5165\u90e8\u95e8\u7684\u7ba1\u7406\u6743\u9650\uff0c\u8bf7\u9009\u62e9\u53ef\u7ba1\u7406\u90e8\u95e8\u8fdb\u884c\u5bfc\u5165");
                    continue;
                }
                employeeDepartWrappersMap.put(dataItem, EmployeeDepartWrapper.create(commandItem, departmentEntity));
                continue;
            }
            dataItem.changeStatus(ProcessedStatus.Error, commandItem.getErrorResult());
        }
        Collection<Map<ImportDataItemEntity, EmployeeDepartWrapper>> employeeDepartWrapperGroups = this.getGroupEmployeeDepartWrappers(employeeDepartWrappersMap, 50);
        CountDownLatch downLatch = new CountDownLatch(employeeDepartWrapperGroups.size());
        for (Map map : employeeDepartWrapperGroups) {
            this.taskExecutor.execute(() -> {
                try {
                    this.executeEmployeeMap(organization, map, importData.getOperator());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.error("\u6267\u884c\u6570\u636e\u53d1\u751f\u5f02\u5e38:id={};path={};mapItem={}", new Object[]{importData.getId(), importData.getPath(), map, ex});
                }
                finally {
                    downLatch.countDown();
                }
            });
        }
        try {
            downLatch.await();
            this.unitWork.executeTran(() -> this.importDataEntityRepository.save(importData));
        }
        catch (Exception ex) {
            log.error("\u5bfc\u5165\u53d1\u751f\u5f02\u5e38:id={};path={}", new Object[]{importData.getId(), importData.getPath(), ex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeEmployeeMap(OrganizationEntity organization, Map<ImportDataItemEntity, EmployeeDepartWrapper> employeeDepartWrapperMap, OperatorValueType operator) {
        if (employeeDepartWrapperMap == null || employeeDepartWrapperMap.size() == 0) {
            return;
        }
        Collection userSameCheckRequests = employeeDepartWrapperMap.values().stream().map(ii -> {
            TenantUserSameCheckRequest request = TenantUserSameCheckRequest.create(ii.getItem().getCredentialType(), ii.getItem().getDataItem().getCredentialNumber(), ii.getItem().getDataItem().getTelephone());
            return request;
        }).collect(Collectors.toList());
        EntryEmployeeValidationException validationException = null;
        try {
            this.tenantUserSameValidator.validate(userSameCheckRequests);
        }
        catch (EntryEmployeeValidationException ex) {
            validationException = ex;
        }
        HashMap employeeEntityMap = new HashMap();
        Iterator<ImportDataItemEntity> iterator = employeeDepartWrapperMap.keySet().iterator();
        while (iterator.hasNext()) {
            ImportDataItemEntity importDataItem = iterator.next();
            EmployeeDepartWrapper employeeDepartWrapper = employeeDepartWrapperMap.get((Object)importDataItem);
            AtomicReference uniqueDataConstraintAtomic = new AtomicReference();
            AtomicReference employeeAtomic = new AtomicReference();
            EmployeeImportedItemSnapshot commandItem = employeeDepartWrapper.getItem().getDataItem();
            try {
                String errorMsg;
                if (validationException != null && StringUtils.hasLength((String)(errorMsg = validationException.getMatchMessage(commandItem.getTelephone(), employeeDepartWrapper.getItem().getCredentialType(), commandItem.getCredentialNumber())))) {
                    employeeDepartWrapper.getItem().addError(errorMsg);
                    continue;
                }
                EmployeeEntity existsEmployee = this.employeeRepository.getIdByOrgIdAndIdCard(organization.getId(), commandItem.getCredentialNumber());
                if (existsEmployee != null) {
                    throw new EmployeeConflictException(existsEmployee);
                }
                this.unitWork.executeTran(() -> {
                    EmployeeEntity employee = EmployeeEntity.create(this.eventDispatcher, organization, employeeDepartWrapper.getDepartment(), commandItem.getName(), commandItem.getTelephone(), null, commandItem.getPositionText(), employeeDepartWrapper.getItem().getHiredDate(), MasterSlaveType.Normal, employeeDepartWrapper.getItem().getCredentialType(), commandItem.getCredentialNumber(), employeeDepartWrapper.getItem().getOccupationType(), commandItem.getNation(), commandItem.getEducation(), commandItem.getPoliticsStatus(), commandItem.getMilitaryStatus(), commandItem.getMaritalStatus(), commandItem.getEmergencyContact(), commandItem.getEmergencyPhone(), commandItem.getAddress(), commandItem.getHouseholdType(), true, operator);
                    employeeEntityMap.put(employeeDepartWrapper, employee);
                    employeeAtomic.set(employee);
                    this.employeeRepository.save((EntityAbstract)employeeAtomic.get());
                    ((EmployeeEntity)((Object)((Object)employeeAtomic.get()))).dispatchAfterCreatedEvent(this.envConfig.isRequiredPhoneAsLoginName());
                });
                continue;
            }
            catch (Exception ex) {
                try {
                    TenantExceptionAbstract tenantExceptionAbstract = TenantExceptionConverter.cast(ex);
                    if (tenantExceptionAbstract != null && (tenantExceptionAbstract instanceof ConflictTenantException || tenantExceptionAbstract instanceof EmployeeConflictException)) {
                        if (employeeAtomic.get() != null) {
                            this.unitWork.detach((IAggregate)employeeAtomic.get());
                        }
                        if (uniqueDataConstraintAtomic.get() != null) {
                            this.unitWork.detach((IAggregate)uniqueDataConstraintAtomic.get());
                        }
                        EmployeeEntity selectedEmployee = null;
                        selectedEmployee = tenantExceptionAbstract instanceof EmployeeConflictException ? ((EmployeeConflictException)tenantExceptionAbstract).getEmployee() : this.employeeRepository.getByIdNum(organization.getId(), commandItem.getCredentialNumber());
                        if (selectedEmployee == null) {
                            employeeDepartWrapper.getItem().addError(String.format("\u65e0\u6cd5\u5165\u804c, \u540c\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4eba\u5458(%s)\u4fe1\u606f, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", commandItem.getCredentialNumber()));
                        }
                        if (selectedEmployee.getStatus() == EmploymentStatus.OnJob) {
                            String errorMsg = "\u8be5\u804c\u5458\u5df2\u7ecf\u5b58\u5728(\u8bf7\u786e\u4fdd\u8be5\u804c\u5458\u672a\u5bfc\u5165\u6216\u8005\u5904\u7406\u79bb\u804c\u72b6\u6001)!";
                            employeeDepartWrapper.getItem().addError(errorMsg);
                        }
                        if (selectedEmployee.getStatus() != EmploymentStatus.OffJob) continue;
                        EmployeeEntity finalSelectedEmployee = selectedEmployee;
                        this.unitWork.executeTran(() -> {
                            this.departmentRepository.clearDuplicatedEmployeeRelationByEmployeeIds(Collections.singleton(finalSelectedEmployee.getId()));
                            finalSelectedEmployee.back(this.eventDispatcher, employeeDepartWrapper.getDepartment(), employeeDepartWrapper.getItem().getOccupationType(), employeeDepartWrapper.getItem().getHiredDate(), operator, false);
                            this.employeeRepository.save(finalSelectedEmployee);
                        });
                        continue;
                    }
                    if (ex instanceof UnexpectedTenantException) {
                        employeeDepartWrapper.getItem().addError(String.format("\u5bfc\u5165\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", ExceptionUtil.getStackMessage((Throwable)ex)));
                    } else {
                        employeeDepartWrapper.getItem().addError(ex.getMessage());
                    }
                    log.error("\u6570\u636e\u9879({})\u5bfc\u5165\u5f02\u5e38", (Object)employeeDepartWrapper.getItem().getDataItem().getCredentialNumber(), (Object)ex);
                }
                catch (Exception ex2) {
                    employeeDepartWrapper.getItem().addError(String.format("\u539f\u59cb\u5f02\u5e38:%s-\u5904\u7406\u5f02\u5e38:%s", ex.getMessage(), ex2.getMessage()));
                    log.error("v2-\u6570\u636e\u9879({})\u5bfc\u5165\u5f02\u5e38\u540e({}); \u5904\u7406\u5f02\u5e38", new Object[]{employeeDepartWrapper.getItem().getDataItem().getCredentialNumber(), ex, ex2});
                }
                continue;
            }
            finally {
                BatchImportEmployeeCommand.EmployeeCommandItem selectedCommandItem = employeeDepartWrapper.getItem();
                ProcessedStatus status = ProcessedStatus.Done;
                if (StringUtils.hasLength((String)selectedCommandItem.getErrorResult())) {
                    status = ProcessedStatus.Error;
                }
                importDataItem.changeStatus(status, selectedCommandItem.getErrorResult());
                continue;
            }
            break;
        }
        return;
    }

    private Collection<Map<ImportDataItemEntity, EmployeeDepartWrapper>> getGroupEmployeeDepartWrappers(Map<ImportDataItemEntity, EmployeeDepartWrapper> wholeWrappers, int pageSize) {
        ArrayList<Map<ImportDataItemEntity, EmployeeDepartWrapper>> group = new ArrayList<Map<ImportDataItemEntity, EmployeeDepartWrapper>>();
        int index = 0;
        HashMap<ImportDataItemEntity, EmployeeDepartWrapper> employeeDepartWrapperMap = null;
        for (ImportDataItemEntity importDataItem : wholeWrappers.keySet()) {
            if (index % pageSize == 0) {
                employeeDepartWrapperMap = new HashMap<ImportDataItemEntity, EmployeeDepartWrapper>();
                group.add(employeeDepartWrapperMap);
            }
            employeeDepartWrapperMap.put(importDataItem, wholeWrappers.get((Object)importDataItem));
            ++index;
        }
        return group;
    }
}

