/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.tenant.domain.configs.TenantUserConfig;
import java.util.Date;
import javax.persistence.Embedded;
import org.springframework.util.StringUtils;

public class BackEmployeeCommand
extends CommandAbstract {
    private final String id;
    private final String organizationId;
    private final String departId;
    private final OccupationType occupationType;
    private Date hiredDate;
    @Embedded
    private final OperatorValueType operator;

    public BackEmployeeCommand(String id, String organizationId, String departId, OccupationType occupationType, Date hiredDate, OperatorValueType operator) {
        this.id = id;
        this.organizationId = organizationId;
        this.departId = departId;
        this.occupationType = occupationType;
        this.hiredDate = hiredDate;
        this.operator = operator;
    }

    public static BackEmployeeCommand create(String id, String organizationId, String departId, OccupationType occupationType, Date hiredDate, OperatorValueType operator) {
        return new BackEmployeeCommand(id, organizationId, departId, occupationType, hiredDate, operator);
    }

    public void setHiredDate(Date hiredDate) {
        this.hiredDate = hiredDate;
    }

    public void validate() {
        this.validate(null);
    }

    public void validate(TenantUserConfig tenantUserConfig) {
        super.validate();
        if (!StringUtils.hasLength((String)this.getId())) {
            throw new BadTenantException("\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new BadTenantException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getDepartId())) {
            throw new BadTenantException("\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getOccupationType() == null) {
            throw new BadTenantException("\u804c\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getHiredDate() == null) {
            throw new BadTenantException("\u5165\u804c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tenantUserConfig != null && tenantUserConfig.isHiredDateMustBeToday() && !DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate((Date)this.getHiredDate()))) {
            throw new ArgumentTenantException("\u5165\u804c\u65e5\u671f\u5fc5\u987b\u662f\u5f53\u5929");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getDepartId() {
        return this.departId;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public OperatorValueType getOperator() {
        return this.operator;
    }
}

