/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class JsonMapConverter
implements AttributeConverter<Map<String, Object>, String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(Map<String, Object> attribute) {
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(attribute);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize dynamicFields to JSON", e);
        }
    }

    public Map<String, Object> convertToEntityAttribute(String dbData) {
        if (dbData == null || dbData.trim().isEmpty()) {
            return new HashMap<String, Object>();
        }
        try {
            Map value = (Map)objectMapper.readValue(dbData, Map.class);
            return value == null ? new HashMap() : value;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize dynamicFields from JSON", e);
        }
    }
}

