/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.OrgRelationStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_org_relation")
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class OrgRelationEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=20)
    private String id;
    @Column(name="relation_status", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private OrgRelationStatus relationStatus;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="last_updated_time")
    private Timestamp lastUpdatedTime;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="org_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    private OrganizationEntity organization;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="parent_org_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    private OrganizationEntity parentOrg;

    public OrgRelationEntity() {
    }

    public OrgRelationEntity(OrganizationEntity organizationEntity, OrganizationEntity parentOrg) {
        this.setOrganization(organizationEntity);
        this.setParentOrg(parentOrg);
    }

    public static OrgRelationEntity create(OrganizationEntity organizationEntity, OrganizationEntity parentOrg) {
        OrgRelationEntity orgRelationEntity = new OrgRelationEntity(organizationEntity, parentOrg);
        orgRelationEntity.setId(UUIDUtil.getShortUuid());
        orgRelationEntity.setRelationStatus(OrgRelationStatus.BIND);
        orgRelationEntity.setCreatedTime(Timestamp.from(Instant.now()));
        orgRelationEntity.setOrganization(organizationEntity);
        orgRelationEntity.setParentOrg(parentOrg);
        return orgRelationEntity;
    }

    public void change(OrgRelationStatus relationStatus) {
        this.setRelationStatus(relationStatus);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public String getId() {
        return this.id;
    }

    public OrgRelationStatus getRelationStatus() {
        return this.relationStatus;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public OrganizationEntity getParentOrg() {
        return this.parentOrg;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setRelationStatus(OrgRelationStatus relationStatus) {
        this.relationStatus = relationStatus;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setParentOrg(OrganizationEntity parentOrg) {
        this.parentOrg = parentOrg;
    }
}

