/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.rbac.domain.entities.RoleEntity;
import com.bcxin.rbac.domain.entities.SubjectEntity;
import com.bcxin.rbac.domain.entities.UserEntity;
import com.bcxin.rbac.domain.events.EnsureSubjectEvent;
import com.bcxin.rbac.domain.repositories.RoleRepository;
import com.bcxin.rbac.domain.repositories.UserRepository;
import com.bcxin.rbac.domain.services.UserService;
import com.bcxin.rbac.domain.services.commands.users.AssignUserCommand;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final EventDispatcher eventDispatcher;
    private final UnitWork unitWork;

    public UserServiceImpl(UserRepository userRepository, RoleRepository roleRepository, EventDispatcher eventDispatcher, UnitWork unitWork) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.eventDispatcher = eventDispatcher;
        this.unitWork = unitWork;
    }

    @Override
    public void dispatch(AssignUserCommand command) {
        command.validate();
        EnsureSubjectEvent ensureSubjectEvent = EnsureSubjectEvent.create(command.getSubjectReferencedId(), String.format("\u7ec4\u7ec7:%s", new Date()));
        this.eventDispatcher.dispatch((DomainEventAbstract)ensureSubjectEvent);
        SubjectEntity subject = (SubjectEntity)((Object)TenantContext.getInstance().getValueAndRemove((Object)ensureSubjectEvent));
        if (subject == null) {
            throw new BadTenantException("\u7ec4\u7ec7(Subject)\u521d\u59cb\u5316\u51fa\u9519");
        }
        Collection roleIds = command.getItems().stream().flatMap(ii -> ii.getRoleIds().stream()).collect(Collectors.toList());
        Collection<RoleEntity> wholeRoles = this.roleRepository.getByIds(roleIds);
        Collection notExistRoleIds = roleIds.stream().filter(ii -> !wholeRoles.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (notExistRoleIds.size() > 0) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u89d2\u8272(%s)\u4fe1\u606f", notExistRoleIds));
        }
        Collection userReferencedIds = command.getItems().stream().map(ii -> ii.getReferencedId()).collect(Collectors.toList());
        Collection<UserEntity> wholeUsers = this.userRepository.getByIds(command.getSubjectReferencedId(), userReferencedIds);
        this.unitWork.executeTran(() -> {
            for (AssignUserCommand.UserCommandItem commandItem : command.getItems()) {
                Optional<UserEntity> userOptional = wholeUsers.stream().filter(ii -> ii.getReferencedId().equals(commandItem.getReferencedId())).findFirst();
                UserEntity user = null;
                user = !userOptional.isPresent() ? UserEntity.create(subject, commandItem.getReferencedId(), commandItem.getName()) : userOptional.get();
                Collection selectedRoles = wholeRoles.stream().filter(ii -> commandItem.getRoleIds().contains(ii)).collect(Collectors.toList());
                user.assignRoles(selectedRoles);
                this.userRepository.save((EntityAbstract)user);
            }
        });
    }
}

