/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.rbac.domain.entities.ResourceEntity;
import com.bcxin.rbac.domain.entities.RoleEntity;
import com.bcxin.rbac.domain.entities.SubjectEntity;
import com.bcxin.rbac.domain.repositories.ResourceRepository;
import com.bcxin.rbac.domain.repositories.RoleRepository;
import com.bcxin.rbac.domain.repositories.SubjectRepository;
import com.bcxin.rbac.domain.services.RoleService;
import com.bcxin.rbac.domain.services.commands.roles.CreateRoleCommand;
import com.bcxin.rbac.domain.services.commands.roles.DeleteRoleCommand;
import com.bcxin.rbac.domain.services.commands.roles.ResourceItem;
import com.bcxin.rbac.domain.services.commands.roles.UpdateRoleCommand;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    private final UnitWork unitWork;
    private final RoleRepository roleRepository;
    private final SubjectRepository subjectRepository;
    private final ResourceRepository resourceRepository;

    public RoleServiceImpl(UnitWork unitWork, RoleRepository roleRepository, SubjectRepository subjectRepository, ResourceRepository resourceRepository) {
        this.unitWork = unitWork;
        this.roleRepository = roleRepository;
        this.subjectRepository = subjectRepository;
        this.resourceRepository = resourceRepository;
    }

    @Override
    public void dispatch(CreateRoleCommand command) {
        AtomicReference subjectAto;
        block5: {
            command.validate();
            Optional subjectOptional = this.subjectRepository.findById(command.getSubjectReferencedId());
            subjectAto = new AtomicReference();
            if (subjectOptional.isPresent()) {
                subjectAto.set(subjectOptional.get());
            }
            if (subjectAto.get() == null) {
                try {
                    this.unitWork.executeTran(() -> {
                        subjectAto.set(SubjectEntity.create(String.format("\u7ec4:%s", new SimpleDateFormat("yyyMMdd").format(new Date())), command.getSubjectReferencedId()));
                        this.subjectRepository.save((EntityAbstract)subjectAto.get());
                    });
                }
                catch (Exception ex) {
                    if (!ExceptionUtil.getStackMessage((Throwable)ex).contains("PRIMARY") || !(subjectOptional = this.subjectRepository.findById(command.getSubjectReferencedId())).isPresent()) break block5;
                    subjectAto.set(subjectOptional.get());
                }
            }
        }
        if (subjectAto.get() == null) {
            throw new BadTenantException("\u89d2\u8272\u521b\u5efa\u5931\u8d25");
        }
        RoleEntity role = RoleEntity.create((SubjectEntity)((Object)subjectAto.get()), command.getName());
        this.assignRoleResources(role, command.getResources());
        this.unitWork.executeTran(() -> this.roleRepository.save((EntityAbstract)role));
    }

    @Override
    public void dispatch(UpdateRoleCommand command) {
        Optional roleOptional = this.roleRepository.findById(command.getId());
        if (roleOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8be5\u89d2\u8272\u4fe1\u606f");
        }
        RoleEntity role = (RoleEntity)((Object)roleOptional.get());
        this.assignRoleResources(role, command.getResources());
        role.change(command.getName());
        this.unitWork.executeTran(() -> this.roleRepository.save((EntityAbstract)role));
    }

    @Override
    public void dispatch(DeleteRoleCommand command) {
        Optional roleOptional = this.roleRepository.findById(command.getId());
        if (!roleOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u89d2\u8272\u4fe1\u606f");
        }
        this.unitWork.executeTran(() -> this.roleRepository.delete((EntityAbstract)roleOptional.get()));
    }

    private void assignRoleResources(RoleEntity role, Collection<ResourceItem> resourceItems) {
        if (resourceItems != null) {
            Collection resourceIds = resourceItems.stream().flatMap(ii -> ii.getResourceIds().stream()).collect(Collectors.toList());
            Collection<ResourceEntity> resources = this.resourceRepository.getByIds(resourceIds);
            Collection notExistsResourceIds = resourceIds.stream().filter(ii -> resources.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
            if (notExistsResourceIds.size() > 0) {
                throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u76ee\u6807\u8d44\u6e90(%s)", notExistsResourceIds.stream().collect(Collectors.joining(","))));
            }
            role.assignResources(resources);
        }
    }
}

