/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.CategoryEntity;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Table(name="rbac_resources")
@Entity
public class ResourceEntity
extends MetaEntityAbstract
implements IAggregate {
    @Id
    @Column(name="id", length=200)
    private String id;
    @Column(name="code", length=200, nullable=false)
    private String code;
    @Column(name="name", length=500)
    private String name;
    @Column(name="data", length=4000)
    private String data;
    @Column(name="tree_path_id", nullable=false, length=255)
    private String treePathId;
    @Column(name="level", nullable=false)
    private int level;
    @Column(name="data_type", length=100, nullable=false)
    private String dataType;
    @ManyToOne
    @JoinColumn(name="parent_id", referencedColumnName="id", nullable=true, foreignKey=@ForeignKey(name="fk_resource_parent_id", value=ConstraintMode.CONSTRAINT))
    private ResourceEntity parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    private Collection<ResourceEntity> resources;
    @Column(name="note", length=500)
    private String note;
    @ManyToOne
    @JoinColumn(name="category_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_resource_category_id", value=ConstraintMode.CONSTRAINT))
    private CategoryEntity category;

    public void change(String code, String name, String data, String dataType) {
        this.setCode(code);
        this.setName(name);
        this.setData(data);
        this.setDataType(dataType);
    }

    public void assignParent(ResourceEntity parent) {
        this.setParent(parent);
        if (parent == null) {
            this.setLevel(0);
            this.setTreePathId(this.getId());
        } else {
            if (parent.getId().equals(this.getId())) {
                throw new NotAllowedTenantException("\u81ea\u8eab\u4e0d\u80fd\u4f5c\u4e3a\u81ea\u5df1\u7684\u7236\u8d44\u6e90\u4fe1\u606f");
            }
            this.setLevel(parent.getLevel() + 1);
            this.setTreePathId(String.format("%s-%s", parent.getTreePathId(), this.getId()));
        }
    }

    protected ResourceEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    protected ResourceEntity(CategoryEntity category) {
        this();
        this.setCategory(category);
    }

    public static ResourceEntity create(CategoryEntity category, String id, String code, String name, String data, String dataType) {
        ResourceEntity resource = new ResourceEntity(category);
        resource.setId(id);
        resource.setTreePathId(resource.getId());
        resource.setLevel(0);
        resource.change(code, name, data, dataType);
        return resource;
    }

    public static ResourceEntity create(CategoryEntity category, String code, String name, String data, String dataType) {
        return ResourceEntity.create(category, UUIDUtil.getShortUuid(), code, name, data, dataType);
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public String getTreePathId() {
        return this.treePathId;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDataType() {
        return this.dataType;
    }

    public ResourceEntity getParent() {
        return this.parent;
    }

    public Collection<ResourceEntity> getResources() {
        return this.resources;
    }

    public String getNote() {
        return this.note;
    }

    public CategoryEntity getCategory() {
        return this.category;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setData(String data) {
        this.data = data;
    }

    protected void setTreePathId(String treePathId) {
        this.treePathId = treePathId;
    }

    protected void setLevel(int level) {
        this.level = level;
    }

    protected void setDataType(String dataType) {
        this.dataType = dataType;
    }

    protected void setParent(ResourceEntity parent) {
        this.parent = parent;
    }

    protected void setResources(Collection<ResourceEntity> resources) {
        this.resources = resources;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setCategory(CategoryEntity category) {
        this.category = category;
    }
}

