package com.bcxin.Infrastructures.hibernates;

import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class CustomInterceptorRegistration implements HibernatePropertiesCustomizer {
    private final DataInterceptor dataInterceptor;

    public CustomInterceptorRegistration(DataInterceptor dataInterceptor) {
        this.dataInterceptor = dataInterceptor;
    }

    @Override
    public void customize(Map<String, Object> hibernateProperties) {
        hibernateProperties.put("hibernate.session_factory.interceptor", this.dataInterceptor);
    }
}
