package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

@Getter
public class EmployeeLeaveGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String telephone;
    private final String departName;
    private String credentialType;
    private final String credentialNumber;
    @JsonFormat(pattern = "yyyy-MM-dd")
    private final Date hiredDate;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private final Date leaveDate;
    private final String leaveNote;
    private final String operatorName;
    protected final Timestamp operatedTime;

    //是否投保
    private final String insure;

    public EmployeeLeaveGetResponse(String id, String name, String telephone,
                                    String departName, CredentialType credentialType,
                                    String credentialNumber,
                                    Date hiredDate,
                                    Date leaveDate, String leaveNote,
                                    String operatorName, Timestamp operatedTime,
                                    String insure) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        if(credentialType != null) {
            this.credentialType = credentialType.getTypeName();
        }
        this.credentialNumber = credentialNumber;
        this.hiredDate = hiredDate;
        this.leaveDate = leaveDate;
        this.leaveNote = leaveNote;
        this.operatorName = operatorName;
        this.operatedTime = operatedTime;
        this.insure = insure;
    }

    public static EmployeeLeaveGetResponse create(String id, String name, String telephone,
                                                  String departName, CredentialType credentialType,
                                                  String credentialNumber,
                                                  Date hiredDate,
                                                  Date leaveDate, String leaveNote,
                                                  String operatorName, Timestamp operatedTime,
                                                  String insure) {
        return new EmployeeLeaveGetResponse(id, name, telephone, departName, credentialType, credentialNumber,
                hiredDate,leaveDate, leaveNote, operatorName, operatedTime,insure);
    }

    public String getLeaveDateText()
    {
        if(this.getLeaveDate()==null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd").format(this.getLeaveDate());
    }

    public String getOperatedTimeText() {
        if (this.getOperatedTime() == null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.getOperatedTime());
    }
}
