package com.bcxin.api.interfaces.tenants.requests.externalMembers;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Collection;

@ApiModel("批量修改团体成员信息")
@Getter
public class UpdateExternalMemberRequest extends RequestAbstract {

    @ApiModelProperty("成员Id")
    private final Collection<String> ids;

    @ApiModelProperty("目标的分组Ids")
    private final Collection<String> groupIds;

    public UpdateExternalMemberRequest(Collection<String> ids,
                                       Collection<String> groupIds) {
        this.ids = ids;
        this.groupIds = groupIds;
    }
}
