package com.bcxin.api.interfaces.tenants.requests.externalMembers;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.api.interfaces.SearchRequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Collection;

@Getter
public class ExternalMemberSearchRequest extends SearchRequestAbstract {
    @ApiModelProperty("关键字搜索")
    private final String keyword;

    @ApiModelProperty("Init=未审核;Passed=审核通过;NoPassed=未通过;Deleted=已被删除; 待加入成员审批界面传递: (Init;Passed;NoPassed)")
    private final Collection<ApprovedStatus> statuses;

    private final Collection<String> groupIds;

    public ExternalMemberSearchRequest(Collection<String> groupIds,String keyword,Collection<ApprovedStatus> statuses,int pageIndex, int pageSize) {
        super(pageIndex, pageSize);

        this.groupIds = groupIds;
        this.keyword = keyword;
        this.statuses = statuses;
    }
}
