package com.bcxin.api.interfaces.tenants.criterias;

import com.bcxin.Infrastructures.enums.ContractStatus;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.api.interfaces.CriteriaAbstract;
import lombok.Data;

import javax.persistence.*;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Data
public class ContractCriteria extends CriteriaAbstract {
    private String keyword;
    private String employeeId;
    private List<String> departIds;

    /**
     * 职业类型
     */
    private List<OccupationType> occupationTypes;

    /**
     * 待入职，入职, 离职申请中，离职
     */
    @Enumerated(EnumType.ORDINAL)
    private EmploymentStatus employmentStatus;

    @Temporal(TemporalType.DATE)
    private Date beginDate;
    @Temporal(TemporalType.DATE)
    private Date endDate;
    /**
     * 合同状态
     */
    private ContractStatus status;


    //按部门、职业类型、在职状态、合同有效期、合同状态
}
