package com.bcxin.Infrastructures.enums;

/**
 * description: 公司类型-枚举类
 * author: linchunpeng
 * date:  2023-05-05 10:58
 */
public enum CompanyNature implements SwaggerDisplayEnum {

    /**
     * 空
     */
    None{
        @Override
        public String getTypeName(){return "空";}
    },

    /**
     * 国有资本
     */
    StateCapital{
        @Override
        public String getTypeName(){return "国有资本";}
    },

    /**
     * 民营
     */
    PrivateSector{
        @Override
        public String getTypeName(){return "民营";}
    },

    /**
     * 外资（包括港澳台投资）
     */
    ForeignCapital{
        @Override
        public String getTypeName(){return "外资（包括港澳台投资）";}
    },

    /**
     * 其它
     */
    Other{
        @Override
        public String getTypeName(){return "其他";}
    };

    public abstract String getTypeName();


    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }

}
