/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.Infrastructures.utils.RedisUtil;
import java.util.Collection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisCacheProviderImpl
implements CacheV2Provider {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheProviderImpl.class);
    private final RedisUtil redisUtil;

    public RedisCacheProviderImpl(RedisUtil redisUtil) {
        this.redisUtil = redisUtil;
    }

    @Override
    public <T> T get(String key, Supplier<T> supplier) {
        return this.get(key, supplier, 120);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(String key, Supplier<T> supplier, int inSeconds) {
        Object data = null;
        try {
            data = this.redisUtil.get(key);
        }
        catch (Exception ex) {
            logger.error("Redis({}).get\u8c03\u7528\u51fa\u9519: \u5f02\u5e38:{}", (Object)key, (Object)ex);
        }
        finally {
            if (data == null || data instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)data))) {
                data = supplier.get();
                this.put(key, data, inSeconds);
            }
        }
        return (T)data;
    }

    @Override
    public <T> void put(String key, T data, int inSeconds) {
        try {
            this.redisUtil.set(key, data, inSeconds);
        }
        catch (Exception ex) {
            logger.error("Redis({}).put\u8c03\u7528\u51fa\u9519: \u5f02\u5e38:{}", (Object)key, (Object)ex);
        }
    }

    @Override
    public void del(String ... keys) {
        try {
            this.redisUtil.del(keys);
        }
        catch (Exception ex) {
            logger.error("Redis({}).del\u8c03\u7528\u51fa\u9519: \u5f02\u5e38:{}", (Object)keys, (Object)ex);
        }
    }

    @Override
    public void delFuzzy(String key) {
        try {
            this.redisUtil.deleteByPrex(key);
        }
        catch (Exception ex) {
            logger.error("Redis({}).delFuzzy\u8c03\u7528\u51fa\u9519: \u5f02\u5e38:{}", (Object)key, (Object)ex);
        }
    }
}

