/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.ContractStatus;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.ValidStatus;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.StringUtils;

public class ContractGetResponse
implements Serializable {
    private final String id;
    private final String name;
    private final String idNum;
    @Enumerated(value=EnumType.ORDINAL)
    private final CredentialType credentialType;
    private final String aName;
    private final String bName;
    private final Date beginDate;
    private final Date endDate;
    private final boolean dateLimitless;
    private final String attachment;
    private final String note;
    private final String employeeId;
    private final String employeeName;
    private final String employeeTelephone;
    private final String employeeDepartName;
    private final OccupationType employeeOccupationType;
    private final EmploymentStatus employeeStatus;
    private final ValidStatus status;
    private final String operator;
    private final String operatorTime;
    private ContractStatus contractStatus;

    public ContractGetResponse(String id, String name, String idNum, CredentialType credentialType, String aName, String bName, String employeeId, String employeeName, String employeeTelephone, String employeeDepartName, OccupationType employeeOccupationType, EmploymentStatus employeeStatus, Date beginDate, Date endDate, TrueFalseStatus dateLimitless, String attachment, String note, ValidStatus status, String operator, String operatorTime, ContractStatus contractStatus) {
        this.id = id;
        this.name = name;
        this.idNum = idNum;
        this.credentialType = credentialType;
        this.aName = aName;
        this.bName = bName;
        this.employeeId = employeeId;
        this.employeeName = employeeName;
        this.employeeTelephone = employeeTelephone;
        this.employeeDepartName = employeeDepartName;
        this.employeeOccupationType = employeeOccupationType;
        this.employeeStatus = employeeStatus;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.dateLimitless = dateLimitless == TrueFalseStatus.True;
        this.attachment = attachment;
        this.note = note;
        this.status = status;
        this.operator = operator;
        this.operatorTime = operatorTime;
        this.contractStatus = contractStatus;
    }

    public String getDateRang() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.getEndDate() == null) {
            return String.format("%s\u81f3\u6c38\u8fdc", dateFormat.format(this.getBeginDate()));
        }
        return String.format("%s\u81f3%s", dateFormat.format(this.getBeginDate()), dateFormat.format(this.getEndDate()));
    }

    public String getEmployeeStatusDesc() {
        if (this.getEmployeeStatus() == EmploymentStatus.OffJob) {
            return "\u79bb\u804c";
        }
        return "\u5728\u804c";
    }

    public String getContractStatusDesc() {
        Date today = new Date();
        Date dueDate = DateUtils.addMonths((Date)new Date(), (int)1);
        String ContractStatusDesc = "";
        this.getContractStatus();
        if (this.getContractStatus() != null) {
            if (this.getContractStatus() == ContractStatus.STOP && this.getStatus() == ValidStatus.InValid || this.getEmployeeStatus() == EmploymentStatus.OffJob || !this.dateLimitless && this.getEndDate() != null && this.getEndDate().before(today)) {
                ContractStatusDesc = "\u7ec8\u6b62";
                return ContractStatusDesc;
            }
            if (this.getContractStatus() == ContractStatus.INCOMPLETE && this.getStatus() == ValidStatus.Valid && !StringUtils.hasLength((String)this.getAttachment())) {
                ContractStatusDesc = "\u5f85\u5b8c\u5584";
                return ContractStatusDesc;
            }
            if (this.getContractStatus() == ContractStatus.BEEFFECT && this.getStatus() == ValidStatus.Valid && this.getBeginDate().after(today)) {
                ContractStatusDesc = "\u5f85\u751f\u6548";
                return ContractStatusDesc;
            }
            if (this.getContractStatus() == ContractStatus.DUE && this.getStatus() == ValidStatus.Valid && this.getEndDate().after(new Date()) && this.getEndDate().before(dueDate) && this.getBeginDate().before(today)) {
                ContractStatusDesc = "\u5373\u5c06\u5230\u671f";
                return ContractStatusDesc;
            }
            if (this.getContractStatus() == ContractStatus.EFFECT) {
                ContractStatusDesc = "\u6709\u6548";
                return ContractStatusDesc;
            }
        } else {
            if (this.getStatus() == ValidStatus.InValid || this.getEmployeeStatus() == EmploymentStatus.OffJob || !this.dateLimitless && this.getEndDate() != null && this.getEndDate().before(today)) {
                ContractStatusDesc = "\u7ec8\u6b62";
                return ContractStatusDesc;
            }
            if (this.getStatus() == ValidStatus.Valid && !StringUtils.hasLength((String)this.getAttachment())) {
                ContractStatusDesc = "\u5f85\u5b8c\u5584";
                return ContractStatusDesc;
            }
            if (this.getStatus() == ValidStatus.Valid && this.getBeginDate().after(today)) {
                ContractStatusDesc = "\u5f85\u751f\u6548";
                return ContractStatusDesc;
            }
            if (this.getStatus() == ValidStatus.Valid && this.getEndDate().after(new Date()) && this.getEndDate().before(dueDate) && this.getBeginDate().before(today)) {
                ContractStatusDesc = "\u5373\u5c06\u5230\u671f";
                return ContractStatusDesc;
            }
            if (this.getStatus() == ValidStatus.Valid && this.getEndDate().after(dueDate) && this.getBeginDate().before(today)) {
                ContractStatusDesc = "\u6709\u6548";
                return ContractStatusDesc;
            }
        }
        return ContractStatusDesc;
    }

    public String getBeginDateDesc() {
        if (this.getBeginDate() == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.getBeginDate());
    }

    public String getEndDateDesc() {
        if (this.getEndDate() == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.getEndDate());
    }

    public String getFileName() {
        if (!StringUtils.hasLength((String)this.getAttachment())) {
            return null;
        }
        if (!this.getAttachment().contains("/")) {
            return this.getAttachment();
        }
        String[] itemNames = this.getAttachment().split("/");
        return itemNames[itemNames.length - 1];
    }

    public static ContractGetResponse create(String id, String name, String idNum, CredentialType credentialType, String aName, String bName, String employeeId, String employeeName, String employeeTelephone, String employeeDepartName, OccupationType employeeOccupationType, EmploymentStatus employeeStatus, Date beginDate, Date endDate, TrueFalseStatus dateLimitless, String attachment, String note, ValidStatus status, String operator, String operatorTime, ContractStatus contractStatus) {
        return new ContractGetResponse(id, name, idNum, credentialType, aName, bName, employeeId, employeeName, employeeTelephone, employeeDepartName, employeeOccupationType, employeeStatus, beginDate, endDate, dateLimitless, attachment, note, status, operator, operatorTime, contractStatus);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdNum() {
        return this.idNum;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String getAName() {
        return this.aName;
    }

    public String getBName() {
        return this.bName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isDateLimitless() {
        return this.dateLimitless;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public String getNote() {
        return this.note;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public String getEmployeeTelephone() {
        return this.employeeTelephone;
    }

    public String getEmployeeDepartName() {
        return this.employeeDepartName;
    }

    public OccupationType getEmployeeOccupationType() {
        return this.employeeOccupationType;
    }

    public EmploymentStatus getEmployeeStatus() {
        return this.employeeStatus;
    }

    public ValidStatus getStatus() {
        return this.status;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getOperatorTime() {
        return this.operatorTime;
    }

    public ContractStatus getContractStatus() {
        return this.contractStatus;
    }
}

