package com.bcxin.bus.domains.components.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.bus.domains.BusConfigProperty;
import com.bcxin.bus.domains.components.MessageProvider;
import com.bcxin.bus.domains.utils.MD5Util;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

@Component
public class
SmsMessageProviderImpl implements MessageProvider {
    public static final String PLATFORM = "platform";
    public static final String SMS_CODE = "smsCode";
    public static final String MOBILE = "mobile";

    private final BusConfigProperty.SmsMessageConfig smsMessageConfig;

    public SmsMessageProviderImpl(BusConfigProperty configProperty) {
        this.smsMessageConfig = configProperty.getSms();
        if (this.smsMessageConfig == null) {
            throw new BadTenantException("初始化参数不正确");
        }
    }

    private static AtomicInteger _counter = new AtomicInteger(1);
    @Override
    public void execute(Map<String, Object> params) {
        if (!params.containsKey(SMS_CODE)) {
            throw new ArgumentTenantException(String.format("短信服务中的: %s参数不能为空", SMS_CODE));
        }
        if (!params.containsKey(MOBILE)) {
            throw new ArgumentTenantException(String.format("短信服务中的: %s参数不能为空", MOBILE));
        }
        String telephone=getTelephone(params);
        String smsCode = (String) params.get(SMS_CODE);
        if(smsMessageConfig.getReceivers()!=null && smsMessageConfig.getReceivers().size()>0 && "B98".equals(smsCode)) {
            int value = _counter.incrementAndGet();
            if (value % 500000 != 0 && value > 0) {
                System.err.println(String.format("不发送新增用户的短信:%s-模板=%s", telephone, smsCode));
                return;
            }
        }

        Map<String, Object> huaWeiSmsContent = new HashMap<>();
        huaWeiSmsContent.put("channel", null);
        huaWeiSmsContent.put("platform", "V5");
        huaWeiSmsContent.put("smsCode", smsCode);
        huaWeiSmsContent.put("mobile", telephone);
        huaWeiSmsContent.put("params", params.get("params"));
        huaWeiSmsContent.put("envi", smsMessageConfig.getEnvi());
        Map<String, Object> smsMessageParams = new HashMap<>();
        String randomKey = RandomUtil.randomNumbers(6);
        smsMessageParams.put("randomKey", randomKey);
        smsMessageParams.put("data", JSON.toJSONString(huaWeiSmsContent));
        smsMessageParams.put("token", MD5Util.string2MD5(String.format("BCXIN%s%s%s", telephone, DateUtil.today(), randomKey)));


        String responseContent = HttpUtil.post(smsMessageConfig.getApi(), smsMessageParams);
        cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(responseContent);
        String status = (String) jsonObject.get("status");
        if (StringUtils.hasLength(status) && status.equals("200")) {
            try {
                System.err.println(String.format("%s: 短信发送成功:手机=%s;smsCode=%s;envi=%s; 结果=%s",
                        new Date(),
                        telephone, smsCode, smsMessageConfig.getEnvi(), responseContent));

            } catch (Exception ex) {
                System.err.println("短信输出打印失败");
                ex.printStackTrace();
            }

            return;
        }else {
            try {
                System.err.println(String.format("短信发送失败:request=%s:response=%s",
                        JSONUtil.parseObj(smsMessageParams),
                        responseContent));
            } catch (Exception ex) {
                System.err.println(String.format("短信发送失败:response=%s",
                        responseContent));
                ex.printStackTrace();
            }
        }

        throw new BadTenantException(String.format("短信发送失败:%s", responseContent));
    }

    //生成随验证码
    public static String verificationCode() {

        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; i++) {
            result += random.nextInt(10);
        }
        return result;
    }

    private String getTelephone(Map<String, Object> params) {
        String telephone = (String) params.get(MOBILE);

        return smsMessageConfig.getFormattedReceiver(telephone);
    }
}
