package com.bcxin.bus.domains;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Collections;
import java.util.Map;

@Data
@ConfigurationProperties("tenant.bus")
public class BusConfigProperty {
    private final static String allKey="all";

    private SmsMessageConfig sms;

    @Data
    public static class SmsMessageConfig {
        private String api;
        private String envi;
        private Map<String, String> receivers;

        public String getFormattedReceiver(String telephone) {
            if (receivers == null || receivers.keySet().size() == 0) {
                return telephone;
            }

            if (this.receivers.containsKey(telephone)) {
                return this.receivers.get(telephone);
            }

            if (this.receivers.containsKey(allKey)) {
                return this.receivers.get(allKey);
            }

            return telephone;
        }
    }
}
