package com.bcxin.Infrastructures.utils;

import org.springframework.util.StringUtils;

public class StringUtil {
    public static String left(String s, int len) {
        if (len < 0)
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        return ((s == null) || (s.length() <= len)) ? s : s.substring(0, len);
    }

    public static boolean equal(String left, String right) {
        if (!StringUtils.hasLength(left) && !StringUtils.hasLength(right)) {
            return true;
        }
        if (!StringUtils.hasLength(left) || !StringUtils.hasLength(right)) {
            return false;
        }

        return left.equalsIgnoreCase(right);
    }
}
