package com.bcxin.Infrastructures.snapshots;

import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

@Data
public class OrgGisLocationSnapshot {
    private Double latitude;
    private Double longitude;
    private Timestamp time;
    private int count;
    private String address;

    public static OrgGisLocationSnapshot create(Double latitude,Double longitude,String address) {
        OrgGisLocationSnapshot snapshot = new OrgGisLocationSnapshot();
        snapshot.setLatitude(latitude);
        snapshot.setLongitude(longitude);
        snapshot.setAddress(address);
        snapshot.setCount(1);
        snapshot.setTime(Timestamp.from(Instant.now()));
        return snapshot;
    }

    public void update(Double latitude,Double longitude,String address){
        if(latitude == null || longitude == null){
            return;
        }
        if(latitude.doubleValue() != this.latitude.doubleValue() || longitude.doubleValue() != this.longitude.doubleValue()){
            this.count++;
            this.setLatitude(latitude);
            this.setLongitude(longitude);
            this.setAddress(address);
        }
    }
}
