package com.bcxin.Infrastructures.queues;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter(AccessLevel.PROTECTED)
public class QueueAbstract {
    public final static int MAX_PRIORITY = 50;
    /**
     * 主要是为了AMQP而定义的, 用于设置topic的routeKey
     */
    private final String routeKey;
    private final String data;
    private final int priority;

    @Setter
    private String queueName;

    protected QueueAbstract(String routeKey, String data, int priority) {
        this.routeKey = routeKey;
        this.data = data;
        this.priority = priority;
    }
}
