package com.bcxin.Infrastructures.entities;

import com.bcxin.Infrastructures.utils.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import java.sql.Timestamp;
import java.time.Instant;

@Embeddable
@Getter
@Setter(AccessLevel.PROTECTED)
public class OperatorValueType extends ValueType {

    private String id;

    private String name;

    private Timestamp createdTime;

    @Transient
    private String operatorTime;

    protected OperatorValueType() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static OperatorValueType create(String id, String name) {
        OperatorValueType operator = new OperatorValueType();
        operator.setId(id);
        operator.setName(name);

        return operator;
    }

    public String getOperatorTime(){
        if(createdTime != null){
            return DateUtil.format2ShortDate(createdTime,"yyyy-MM-dd HH:mm:ss");
        }
        return null;
    }
}

