package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Getter
public class UserDetailGetResponse extends UserProfileGetResponse {

    /**
     * 邮箱
     */
    private final String email;

    @ApiModelProperty(value = "证件信息", required = true)
    private final CredentialInfo credential;

    public UserDetailGetResponse(String id, String name, String email, String nicky,
                                 String telephone,
                                 String lonLatJson,
                                 Date birthdate,
                                 UserCheckedStatus checkedStatus,
                                 RealNameAuthenticatedStatus authenticateStatus,
                                 String authenticatedResult,
                                 String stature,
                                  String headPhoto,
                                 Sex sex, String nation,Integer workYear,String diseasesHistory,
                                 String politicsStatus,
                                 String militaryStatus,
                                 String education,
                                 String householdType,
                                 String nativePlace,
                                 String maritalStatus,
                                 String oneInchColorWhitePhoto,
                                 String twoInchColorBluePhoto,
                                 String cid,
                                 String emergencyContact,
                                 String emergencyPhone,
                                 String licenseLevel,
                                 String thirdPartyLoginNo,
                                 String imIdentity,
                                 LocationRequest placeOfNow,
                                 CredentialInfo credential,
                                 List<TenantUserExtensionResponse> extensionList) {
        super(id, name, telephone, lonLatJson, birthdate,
                checkedStatus, authenticateStatus, authenticatedResult,
                stature,
                headPhoto, nicky, sex, nation, diseasesHistory, workYear, politicsStatus,
                militaryStatus, education, householdType, nativePlace, maritalStatus,
                oneInchColorWhitePhoto, twoInchColorBluePhoto, cid,
                emergencyContact,
                emergencyPhone,
                licenseLevel,
                thirdPartyLoginNo,
                imIdentity,
                placeOfNow,
                null,null,null, extensionList);
        this.email = email;
        this.credential = credential;
    }

    public static UserDetailGetResponse create(String id, String name, String email, String nicky,
                                               String telephone,
                                               String lonLatJson,
                                               Date birthdate,
                                               UserCheckedStatus checkedStatus,
                                               RealNameAuthenticatedStatus authenticateStatus,
                                               String authenticatedResult,
                                               String stature,
                                               String headPhoto,
                                               Sex sex, String nation,
                                               Integer workYear,String diseasesHistory,
                                               String politicsStatus,
                                               String militaryStatus,
                                               String education,
                                               String householdType,
                                               String nativePlace,
                                               String maritalStatus,
                                               String oneInchColorWhitePhoto,
                                               String twoInchColorBluePhoto,
                                               String cid,
                                               String emergencyContact,
                                               String emergencyPhone,
                                               String licenseLevel,
                                               String thirdPartyLoginNo,
                                               String imIdentity,
                                               LocationRequest placeOfNow,
                                               CredentialInfo credential,
                                               List<TenantUserExtensionResponse> extensionList) {
        return new UserDetailGetResponse(id, name, email, nicky,
                telephone, lonLatJson, birthdate,
                checkedStatus, authenticateStatus, authenticatedResult,
                stature,
                headPhoto, sex, nation, workYear,diseasesHistory,politicsStatus,
                militaryStatus, education, householdType, nativePlace, maritalStatus,
                oneInchColorWhitePhoto, twoInchColorBluePhoto, cid,
                emergencyContact,
                emergencyPhone,
                licenseLevel,
                thirdPartyLoginNo,
                imIdentity,
                placeOfNow, credential, extensionList);
    }

    @Getter
    public static class CredentialInfo implements Serializable {
        @ApiModelProperty(value = "证件类型")
        private final CredentialType credentialType;

        @ApiModelProperty(value = "姓名")
        private final String name;

        @ApiModelProperty(value = "人头像")
        private final String headPhoto;

        @ApiModelProperty(value = "证件号码")
        private final String number;

        @ApiModelProperty(value = "有效期从")
        private final Date validDateFrom;

        @ApiModelProperty(value = "有效期从")
        private final Date validDateTo;

        @ApiModelProperty(value = "身份证人像面")
        private final String frontPhoto;

        @ApiModelProperty(value = "身份证国徽面")
        private final String reversePhoto;

        @ApiModelProperty(value = "身份证地址")
        private final String address;

        public String getValidRang() {
            if (validDateFrom == null) {
                return null;
            }

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (validDateTo == null) {
                return String.format("%s至永久", simpleDateFormat.format(this.getValidDateFrom()));
            }

            return String.format("%s至%s", simpleDateFormat.format(this.getValidDateFrom()), simpleDateFormat.format(this.getValidDateTo()));
        }

        public CredentialInfo(String name,
                              String headPhoto,
                              CredentialType credentialType,
                              String number,
                              Date validDateFrom,
                              Date validDateTo,
                              String frontPhoto,
                              String reversePhoto,
                              String address) {
            this.name = name;
            this.headPhoto = CdnUtils.convert(headPhoto);
            this.credentialType = credentialType;
            this.number = number;
            this.validDateFrom = validDateFrom;
            this.validDateTo = validDateTo;
            this.frontPhoto = CdnUtils.convert(frontPhoto);
            this.reversePhoto = CdnUtils.convert(reversePhoto);
            this.address = address;
        }

        public static CredentialInfo create(String name,
                                            String headPhoto,
                                            CredentialType credentialType,
                                            String number,
                                            Date validDateFrom,
                                            Date validDateTo,
                                            String frontPhoto,
                                            String reversePhoto,
                                            String address) {
            return new CredentialInfo(name, headPhoto, credentialType, number, validDateFrom, validDateTo, frontPhoto, reversePhoto, address);
        }
    }
}
