package com.bcxin.api.interfaces.tenants.requests.organizationRelationship;

import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

@ApiModel("添加集团组织关系表请求对象")
@Data
public class OrganizationRelationshipCreateRequest extends RequestAbstract {

   /* @ApiModelProperty(value = "上级组织")
    private String parentId;

    @ApiModelProperty(value = "上级组织名称")
    private String parentName;*/

    @ApiModelProperty(value = "选中的组织Id", required = true)
    @NotBlank(message = "选中的组织Id不能为空")
    private String selectedOrganizationId;

    @ApiModelProperty(value = "选中的组织名称", required = true)
    @NotBlank(message = "选中的组织名称不能为空")
    private String selectedOrganizationName;

    /*@ApiModelProperty(value = "组织编码")
    private String code;
*/
   /* @ApiModelProperty(value = "联系人姓名", required = true)
    @NotBlank(message = "联系人姓名不能为空")
    private String contactName;

    @ApiModelProperty(value = "联系人手机", required = true)
    @NotBlank(message = "联系人手机不能为空")
    private String contactTelephone;*/

   /* @ApiModelProperty(value = "组织类型编码")
    private long organizationTypeId;

    @ApiModelProperty(value = "组织关系索引树")
    private String relationshipIndexTree;

    @ApiModelProperty(value = "组织状态")
    private RelationshipsStatus status;

    @ApiModelProperty(value = "回复的备注")
    private String lastReplyNote;

    @ApiModelProperty(value = "回复人")
    private String lastReplyEmployeeId;

    @ApiModelProperty(value = "回复人姓名")
    private String lastReplyEmployeeName;

    @ApiModelProperty(value = "最后回复时间")
    private String lastReplyTime;

    @ApiModelProperty(value = "集团组织的Id")
    private  String organizationId;*/

    @ApiModelProperty(value = "邀请类型", required = true)
    @NotNull(message = "邀请类型不能为空")
    private InviteType inviteType;

    @ApiModelProperty(value = "集团码")
    private String groupCode;

}
