package com.bcxin.api.interfaces.tenants.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.enums.DepartImPermissionType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;

@Data
public class DepartmentRequest extends RequestAbstract {

    @ApiModelProperty(value = "部门名称")
    @NotEmpty(message = "部门名称不能为空")
    private String name;

    @ApiModelProperty(value = "上级部门")
    private String parentId;

    @ApiModelProperty(value = "排序")
    private int displayOrder;

    @NotNull(message = "通讯录权限不能为空")
    @ApiModelProperty(value = "通讯录权限类型", allowEmptyValue = false,
            allowableValues = "JustOnDepart, OnDepartAndSub, JustSelf, Whole, Special")
    private DepartImPermissionType permissionType;

    @ApiModelProperty("当通讯录权限指定为: 可见指定部门; 用户需要选择该列表")
    private Collection<String> allowedDepartIds;

    @ApiModelProperty(value = "设置为部门主管的员工id列表")
    private List<String> leaderEmployeeIdList;
}
