/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.JwtUtil;
import com.bcxin.Infrastructures.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class BjNwJwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);
    public static final String PSC_TOKEN_PREFIX = "psc_token_";
    private static final String SIGNATURE_KEY = "!@#zhian123O0zhang";
    private static final Algorithm SIGNATURE_ALGORITHM;
    private static final long SURVIVAL_TIME = 86400000L;
    private static final long NO_OPERATION_TIME = 3600L;

    public String createToken(Map<String, String> verifyInfoMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alg", "HS256");
        map.put("typ", "JWT");
        String token = JWT.create().withHeader(map).withExpiresAt(new Date(System.currentTimeMillis() + 86400000L)).withClaim("idNo", verifyInfoMap.get("idNo")).withClaim("name", verifyInfoMap.get("name")).withClaim("ukeySn", verifyInfoMap.get("ukeySn")).withClaim("organCode", verifyInfoMap.get("organCode")).withClaim("organName", verifyInfoMap.get("organName")).withClaim("orgLevel", verifyInfoMap.get("orgLevel")).withClaim("roleCode", verifyInfoMap.get("roleCode")).withClaim("thirdLevelOrgCode", verifyInfoMap.get("thirdLevelOrgCode")).withClaim("secondLevelOrgCode", verifyInfoMap.get("secondLevelOrgCode")).sign(SIGNATURE_ALGORITHM);
        token = Base64Utils.encodeToString((byte[])token.getBytes(StandardCharsets.UTF_8));
        return token;
    }

    public Map<String, String> verifyToken(String token) throws JWTVerificationException, BadTenantException {
        DecodedJWT jwt = null;
        try {
            token = new String(Base64Utils.decodeFromString((String)token), StandardCharsets.UTF_8);
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SIGNATURE_KEY)).build();
            jwt = verifier.verify(token);
            String idNo = jwt.getClaim("idNo").asString();
            if (StringUtils.isEmpty(idNo)) {
                logger.error("token\u643a\u5e26\u53c2\u6570\u4e0d\u5b8c\u6574");
                throw new BadTenantException("token\u643a\u5e26\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
        }
        catch (Exception e) {
            if (StringUtils.isNotEmpty(e.getMessage()) && e.getMessage().contains("The Token has expired on Sat")) {
                throw new BadTenantException("token\u89e3\u7801\u5f02\u5e38\uff1atoken\u5df2\u8fc7\u671f");
            }
            logger.error(e.getMessage());
            throw new BadTenantException("token\u89e3\u7801\u5f02\u5e38\uff1a" + e.getMessage());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("idNo", jwt.getClaim("idNo").asString());
        result.put("name", jwt.getClaim("name").asString());
        result.put("ukeySn", jwt.getClaim("ukeySn").asString());
        result.put("organCode", jwt.getClaim("organCode").asString());
        result.put("organName", jwt.getClaim("organName").asString());
        result.put("orglevel", jwt.getClaim("orglevel").asString());
        result.put("roleCode", jwt.getClaim("roleCode").asString());
        result.put("thirdLevelOrgCode", jwt.getClaim("thirdLevelOrgCode").asString());
        result.put("secondLevelOrgCode", jwt.getClaim("secondLevelOrgCode").asString());
        return result;
    }

    static {
        try {
            SIGNATURE_ALGORITHM = Algorithm.HMAC256((String)SIGNATURE_KEY);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

