package com.bcxin.ferry.scheduling;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.common.queue.DetailFileQueue;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.service.FerryReceiveTaskFileService;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：从明细文件队列取值并操作
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class DetailFileReceiveQueueTake {

    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private FerryReceiveTaskFileService ferryReceiveTaskFileService;

    @Scheduled(cron = "10 */1 * * * ?")
    public void queueTake() {
        log.info("===================================定时从明细文件队列取值并操作===================================");
        while (DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.size() > 0) {
            String data = null;
            try {
                log.info("明细文件队列有值，大小：{}，可以取值", DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.size());
                data = DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.take();
                FerryFileDto ferryFileDto = JSONObject.parseObject(data, FerryFileDto.class);
                log.info("接收明细文件策略，基本参数");
                log.info("ferryTaskId：{}", ferryFileDto.getFerryTaskId());
                log.info("requestId：{}", ferryFileDto.getRequestId());
                log.info("fileId：{}", ferryFileDto.getFileId());
                log.info("fileType：{}", ferryFileDto.getFileType());
                //修改接收任务状态-接收明细文件开始
                ferryReceiveTaskService.updateTaskStatusReceiveDetailFileBegin(Long.parseLong(ferryFileDto.getFerryTaskId()));
                //接收文件
                if (ferryFileDto.getFileType() != FileTypeEnum.NORMAL.getCode()) {
                    //文件类型不是普通文件
                    log.info("文件类型不是普通文件，需要转文件的base64字符串，文件id：{}", ferryFileDto.getFileId());
                    ferryFileDto.putFileContent(data);
                }
                boolean receiveTaskFileSuccess = ferryReceiveTaskFileService.receiveTaskDetailFile(Long.parseLong(ferryFileDto.getFileId()), ferryFileDto.getImg_base64());
                if (receiveTaskFileSuccess) {
                    //回调
                    ferryReceiveTaskFileService.callbackToBoundary(Long.parseLong(ferryFileDto.getFileId()), SendBoundaryUrlEnum.SEND_DETAIL_FILE_CALLBACK);
                    //修改接收任务状态-接收明细文件完成
                    ferryReceiveTaskService.updateTaskStatusReceiveDetailFileComplete(Long.parseLong(ferryFileDto.getFerryTaskId()));
                }
            } catch (Exception e) {
                e.printStackTrace();
                log.error("定时从明细文件队列取值并操作异常，{}", e.getMessage(), e);
                if (StringUtils.isNotBlank(data)) {
                    try {
                        log.info("定时从明细文件队列取值并操作异常，参数放入队列");
                        DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.put(data);
                        log.info("定时从明细文件队列取值并操作异常，参数放入队列，完成");
                    } catch (InterruptedException ie) {
                        ie.printStackTrace();
                        log.error("定时从明细文件队列取值并操作异常，参数放入队列异常，{}", ie.getMessage(), ie);
                    }
                }
            }
        }
        log.info("===================================定时从明细文件队列取值并操作结束===================================");
    }

}
