package com.bcxin.ferry.common.emus;

/**
 * 文件类型，1-任务文件，2-sql文件，3-普通文件，4-子文件（拆分），5-txt文件，6-特殊字符名称文件
 */
public enum FileTypeEnum {

    //任务文件
    TASK(1, "任务文件"),
    //sql文件
    SQL(2, "sql文件"),
    //普通文件
    NORMAL(3, "普通文件"),
    //子文件（拆分）
    CHILDREN(4, "子文件（拆分）"),
    //txt文件
    TXT(5, "txt文件"),
    //txt文件
    SPECIAL(6, "特殊字符名称文件");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    FileTypeEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
