/*
 * Decompiled with CFR 0.152.
 */
package com.baichuanxin.openrestapi.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.common.utils.FileHandleUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.configs.OneTaskConfig;
import com.baichuanxin.openrestapi.dao.mapper.RegistrationBranchMapper;
import com.baichuanxin.openrestapi.dtos.AttachDto;
import com.baichuanxin.openrestapi.dtos.RegisterBranchDto;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.RegionCode;
import com.baichuanxin.openrestapi.entity.RegistrationBranch;
import com.baichuanxin.openrestapi.service.TaskInfoService;
import com.baichuanxin.openrestapi.service.impl.AttachTaskInfoServiceImpl;
import com.baichuanxin.openrestapi.service.impl.RegionCodeServiceImpl;
import com.baichuanxin.openrestapi.service.impl.SecurityManTaskInfoServiceImpl;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegistrationBranchTaskInfoServiceImpl
extends ServiceImpl<RegistrationBranchMapper, RegistrationBranch>
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(RegistrationBranchTaskInfoServiceImpl.class);
    @Autowired
    private OneTaskConfig oneTaskConfig;
    @Autowired
    private AttachTaskInfoServiceImpl attachTaskInfoService;
    @Autowired
    private SecurityManTaskInfoServiceImpl securityManTaskInfoService;
    @Autowired
    private RegionCodeServiceImpl regionCodeService;

    @Transactional(rollbackFor={Exception.class})
    public boolean saveTaskInfo(Notice notice) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"taskId", (Object)notice.getTaskId());
        RegistrationBranch one = (RegistrationBranch)this.getOne((Wrapper)queryWrapper);
        if (one != null) {
            log.info("==\u6570\u636e\u5df2\u7ecf\u5b58\u5728:taskId:{}", (Object)notice.getTaskId());
            return true;
        }
        Map formJson = notice.getFormJson();
        RegisterBranchDto registerBranchDto = (RegisterBranchDto)JSON.parseObject((String)JSON.toJSONString((Object)formJson), RegisterBranchDto.class);
        RegistrationBranch registrationBranch = registerBranchDto.convert(notice);
        RegionCode regionCode = this.regionCodeService.getRegionCode(registrationBranch.getItemOfficePoliceAddress());
        registrationBranch.setItemOfficePoliceAddress(regionCode.getName());
        registrationBranch.setItemitemOfficePoliceAddressid(regionCode.getId());
        registrationBranch.setItemOfficePoliceidindex(regionCode.getIndexTree());
        boolean saveResult = this.save((Object)registrationBranch);
        boolean saveManResult = this.securityManTaskInfoService.saveOtherInfo(notice.getTaskId(), registerBranchDto.getBayxx(), registrationBranch.getId());
        boolean saveFileDataResult = this.attachTaskInfoService.saveOtherInfo(notice, registrationBranch.getId());
        List attachList = notice.getAttachList();
        Map<String, List<AttachDto>> map = attachList.stream().collect(Collectors.groupingBy(AttachDto::getMaterialId));
        for (String key : map.keySet()) {
            List<AttachDto> attachDtos = map.get(key);
            int i = 1;
            for (AttachDto attachDto : attachDtos) {
                try {
                    FileHandleUtil.saveApplyFileHandle((String)StrUtil.join((CharSequence)"", (Object[])new Object[]{this.oneTaskConfig.getDownloadUrl(), attachDto.getAttachPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), attachDto.getMaterialId(), i}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), attachDto.getMaterialId(), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{attachDto.getMaterialName(), attachDto.getAttachType()})}));
                    ++i;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return saveFileDataResult && saveResult && saveManResult;
    }

    public List<String> returnTaskResult(List<Notice> noticeList) {
        ArrayList<String> mapList = new ArrayList<String>();
        ArrayList<String> taskIdList = new ArrayList<String>();
        for (Notice notice : noticeList) {
            taskIdList.add(notice.getTaskId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"taskId", taskIdList);
        queryWrapper.in((Object)"ITEM_AUDITSTATUS", new Object[]{"0", "1"});
        List list = this.list((Wrapper)queryWrapper);
        for (RegistrationBranch registrationBranch : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("taskId", registrationBranch.getTaskId());
            map.put("userName", "\u6e56\u5357\u7701\u4fdd\u5b89\u76d1\u7ba1\u4fe1\u606f\u7cfb\u7edf");
            map.put("eventName", OnlineTaskUtil.convertStatus((String)registrationBranch.getItemAuditStatus()));
            map.put("opinion", OnlineTaskUtil.convertStatus((String)OnlineTaskUtil.convertStatus((String)registrationBranch.getItemAuditStatus())));
            map.put("endTime", DateUtil.dateFormatter((Date)registrationBranch.getItemOverTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            map.put("isdelivery", registrationBranch.getIsdelivery());
            boolean b1 = OnlineTaskUtil.returnResult((String)JSON.toJSONString(map));
            if (!b1) continue;
            mapList.add(registrationBranch.getTaskId());
        }
        return mapList;
    }
}

