/*
 * Decompiled with CFR 0.152.
 */
package com.baichuanxin.openrestapi.scheduling;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.common.utils.FileHandleUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.ChangeLegalPerson;
import com.baichuanxin.openrestapi.entity.ECSysConfig;
import com.baichuanxin.openrestapi.entity.LicenseInformation;
import com.baichuanxin.openrestapi.entity.SecurityServicek;
import com.baichuanxin.openrestapi.service.ECSysconfigService;
import com.baichuanxin.openrestapi.service.impl.ChangeLegalPersonTaskInfoServiceImpl;
import com.baichuanxin.openrestapi.service.impl.LicenseInformationServiceImpl;
import com.baichuanxin.openrestapi.service.impl.SecurityServicekTaskInfoServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ECTask {
    private static final Logger log = LoggerFactory.getLogger(ECTask.class);
    @Autowired
    private ECSysconfigService ecSysconfigService;
    @Autowired
    private SecurityServicekTaskInfoServiceImpl service;
    @Autowired
    private LicenseInformationServiceImpl licenseInformationServiceImpl;
    @Autowired
    private ChangeLegalPersonTaskInfoServiceImpl cPersonService;

    @Scheduled(fixedDelay=43200000L)
    public void getTokenTask() {
        log.info("\u5f00\u59cb\u83b7\u53d6\u7535\u5b50\u8bc1\u7167token\u4efb\u52a1");
        String token = this.getToken();
        this.ecSysconfigService.updateToken(token);
        log.info("\u7ed3\u675f\u83b7\u53d6\u7535\u5b50\u8bc1\u7167token\u4efb\u52a1");
    }

    @Scheduled(fixedDelay=180000L)
    public void ECSubmitDataTask() {
        log.info("============\u5f00\u59cb\u8fdb\u884c\u8bc1\u4e66\u7b7e\u7ae0==>\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb\u63d0\u4ea4\u7167\u9762\u6570\u636e======================");
        ECSysConfig one = this.ecSysconfigService.getOne();
        String ecToken = one.getConfigValue();
        List serviceList = this.service.getUnGetEC();
        List dataList = this.getECInformationHandel(serviceList);
        for (Map itemMap : dataList) {
            String xml = OnlineTaskUtil.handleXml((Map)itemMap);
            String holderCode = (String)itemMap.get("holderCode");
            String unId = (String)itemMap.get("unid");
            String name = (String)itemMap.get("holder");
            Map strMap = OnlineTaskUtil.xmlDataSend((String)xml, (String)unId, (String)ecToken);
            String fileNumber = (String)strMap.get("fileNumber");
            String licenseId = (String)strMap.get("licenseId");
            log.error("\u6587\u4ef6\u7f16\u7801\uff1a{}\uff0c\u6587\u4ef6id{}", (Object)fileNumber, (Object)licenseId);
            if (!StrUtil.isNotBlank((CharSequence)fileNumber) || !StrUtil.isNotBlank((CharSequence)licenseId)) continue;
            LicenseInformation licenseInformation = new LicenseInformation();
            licenseInformation.setId(unId);
            licenseInformation.setLicenseId(licenseId);
            licenseInformation.setFileNumber(fileNumber);
            licenseInformation.setUscc(holderCode);
            licenseInformation.setName(name);
            licenseInformation.setStatus(Integer.valueOf(0));
            this.licenseInformationServiceImpl.addLicenseInformation(licenseInformation);
            this.service.updateLicenseStatus(unId, "1");
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void changeECSubmitDataTask() {
        log.info("============\u5f00\u59cb\u8fdb\u884c\u8bc1\u4e66\u7b7e\u7ae0==>\u6cd5\u4eba\u53d8\u66f4\u63d0\u4ea4\u7167\u9762\u6570\u636e======================");
        ECSysConfig one = this.ecSysconfigService.getOne();
        String ecToken = one.getConfigValue();
        List changeLegalPersonList = this.cPersonService.getUnGetEC();
        List dataList = this.getCPersonECInformationHandel(changeLegalPersonList);
        for (Map itemMap : dataList) {
            List licenseList = this.licenseInformationServiceImpl.getByUscc((String)itemMap.get("holderCode"));
            String xml = OnlineTaskUtil.handleXml((Map)itemMap);
            String holderCode = (String)itemMap.get("holderCode");
            String unId = (String)itemMap.get("unid");
            String name = (String)itemMap.get("holder");
            if (licenseList.isEmpty()) {
                Map strMap = OnlineTaskUtil.xmlDataSend((String)xml, (String)unId, (String)ecToken);
                String fileNumber = (String)strMap.get("fileNumber");
                String licenseId = (String)strMap.get("licenseId");
                log.error("\u6587\u4ef6\u7f16\u7801\uff1a{}\uff0c\u6587\u4ef6id{}", (Object)fileNumber, (Object)licenseId);
                if (!StrUtil.isNotBlank((CharSequence)fileNumber) || !StrUtil.isNotBlank((CharSequence)licenseId)) continue;
                LicenseInformation licenseInformation = new LicenseInformation();
                licenseInformation.setId(unId);
                licenseInformation.setLicenseId(licenseId);
                licenseInformation.setFileNumber(fileNumber);
                licenseInformation.setUscc(holderCode);
                licenseInformation.setName(name);
                licenseInformation.setStatus(Integer.valueOf(0));
                this.licenseInformationServiceImpl.addLicenseInformation(licenseInformation);
                this.cPersonService.updateLicenseStatus(unId, "0");
                continue;
            }
            int i = OnlineTaskUtil.updateXmlDataSend((String)ecToken, (String)((LicenseInformation)licenseList.get(0)).getLicenseId(), (String)xml, (String)unId);
            if (i != 0) continue;
            this.cPersonService.updateLicenseStatus(unId, "1");
            LicenseInformation licenseInformation = (LicenseInformation)licenseList.get(0);
            licenseInformation.setLicenseId(unId);
            licenseInformation.setStatus(Integer.valueOf(0));
            this.licenseInformationServiceImpl.addLicenseInformation(licenseInformation);
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void getECFileTask() {
        List licenseInfomations = this.licenseInformationServiceImpl.get("0");
        try {
            List fileList = licenseInfomations.stream().map(item -> {
                HashMap<String, String> itemMap = new HashMap<String, String>();
                itemMap.put("id", item.getId());
                itemMap.put("fileNumber", item.getFileNumber());
                itemMap.put("status", item.getStatus().toString());
                itemMap.put("name", item.getName());
                return itemMap;
            }).collect(Collectors.toList());
            for (Map itemMap : fileList) {
                String fileNumber = OnlineTaskUtil.getFileRequest((String)((String)itemMap.get("fileNumber")));
                String fileName = (String)itemMap.get("name");
                String id = (String)itemMap.get("id");
                if (!fileNumber.isEmpty()) {
                    String ecFilePath = FileHandleUtil.fileSave((String)fileNumber, (String)id, (String)fileName);
                    this.licenseInformationServiceImpl.updateStatusById(id, "1");
                    ArrayList lists = new ArrayList();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("uid", id);
                    map.put("path", StrUtil.join((CharSequence)"/", (Object[])new Object[]{"/uploads/ecfile", id, StrUtil.join((CharSequence)".", (Object[])new Object[]{fileName, "ofd"})}));
                    map.put("originalPath", StrUtil.join((CharSequence)"/", (Object[])new Object[]{"/uploads/ecfile", id, StrUtil.join((CharSequence)".", (Object[])new Object[]{fileName, "ofd"})}));
                    map.put("name", StrUtil.join((CharSequence)".", (Object[])new Object[]{fileName, "ofd"}));
                    lists.add(map);
                    this.service.updateStatusAndfile(id, "2", JSON.toJSONString(lists));
                    this.cPersonService.updateStatusAndfile(id, "2", JSON.toJSONString(lists));
                    continue;
                }
                log.error("{} \u8fd8\u672a\u5b8c\u6210\u76d6\u7ae0", (Object)id);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getToken() {
        String accessToken = "false";
        String getTokenUrl = "http://65.26.106.115:8003/license-api-release/oauth/token";
        HashMap<String, String> formDataMap = new HashMap<String, String>();
        formDataMap.put("client_id", "linewell-oauth");
        formDataMap.put("client_secret", "linewell-mobile");
        formDataMap.put("grant_type", "password");
        formDataMap.put("scope", "readwrite");
        formDataMap.put("username", "dzzz_bajgxxxt");
        formDataMap.put("password", "Bajgxxxt_6777");
        HttpResponse execute = ((HttpRequest)HttpUtil.createPost((String)getTokenUrl).header("Content-Type", "application/x-www-form-urlencoded")).form(formDataMap).execute();
        String responseBody = execute.body();
        if (execute.isOk()) {
            Map resMap = (Map)JSON.parseObject((String)execute.body(), Map.class);
            accessToken = (String)resMap.get("access_token");
            log.error("\u83b7\u53d6\u7535\u5b50\u8bc1\u7167token\u54cd\u5e94\u4f53:{}", (Object)responseBody);
        }
        return accessToken;
    }

    public List<Map<String, String>> getECInformationHandel(List<SecurityServicek> serviceList) {
        List<Map<String, String>> mapList = serviceList.stream().map(item -> {
            HashMap<String, String> par = new HashMap<String, String>();
            String licenseNumber = item.getItemServiceNumber();
            par.put("licenseNumber", licenseNumber);
            String issueDate = DateUtil.dateFormatter((Date)item.getItemOverTime(), (String)"yyyy-MM-dd");
            log.info("+++++\u7ed3\u675f\u65f6\u95f4{}", (Object)issueDate);
            par.put("issueDate", issueDate);
            String holder = item.getItemCompanyName();
            par.put("holder", holder);
            String holderCode = item.getItemLegalCardnumber();
            par.put("holderCode", holderCode);
            String zs = item.getItemAddress();
            par.put("zs", zs);
            String fddbr = item.getItemLegalName();
            par.put("fddbr", fddbr);
            String itemBusinessscope = item.getItemBusinessScope();
            par.put("fwfw", OnlineTaskUtil.strHandle((String)itemBusinessscope));
            String zczb = item.getItemRegisteredCapital();
            par.put("zczb", zczb);
            String pzwh = item.getItemCodeNumber();
            par.put("pzwh", pzwh);
            String ID = item.getID();
            par.put("unid", ID);
            return par;
        }).collect(Collectors.toList());
        return mapList;
    }

    public List<Map<String, String>> getCPersonECInformationHandel(List<ChangeLegalPerson> changeLegalList) {
        List<Map<String, String>> mapList = changeLegalList.stream().map(item -> {
            HashMap<String, String> par = new HashMap<String, String>();
            String licenseNumber = item.getItemSecurityTrainPermitNo();
            par.put("licenseNumber", licenseNumber);
            String issueDate = DateUtil.dateFormatter((Date)item.getItemOverTime(), (String)"yyyy-MM-dd");
            par.put("issueDate", issueDate);
            log.info("+++++\u7ed3\u675f\u65f6\u95f4{}", (Object)issueDate);
            String holder = item.getItemCompanyName();
            par.put("holder", holder);
            String holderCode = item.getItemUscc();
            par.put("holderCode", holderCode);
            String zs = item.getItemAddress();
            par.put("zs", zs);
            String fddbr = item.getItemAppointmentLegalName();
            par.put("fddbr", fddbr);
            String itemBusinessscope = item.getItemBusinessScope();
            par.put("fwfw", OnlineTaskUtil.strHandle((String)itemBusinessscope));
            String zczb = item.getItemRegisteredCapital();
            par.put("zczb", zczb);
            String pzwh = item.getItemApprovalNumber();
            par.put("pzwh", pzwh);
            String ID = item.getId();
            par.put("unid", ID);
            return par;
        }).collect(Collectors.toList());
        return mapList;
    }
}

