/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public class RdDeviceDeskPermissionResponse
extends ResponseAbstract {
    private Collection<RdDeviceDeskServiceScopeResponse> serviceScopes;

    public boolean isSuperviseDesk() {
        if (this.getServiceScopes() == null || this.getServiceScopes().size() == 0) {
            return false;
        }
        return this.getServiceScopes().stream().anyMatch(ii -> ii.getAssignedSuperviseDepartId() != null && !ii.getAssignedSuperviseDepartId().isEmpty());
    }

    public Collection<RdDeviceDeskServiceScopeResponse> getAllowedServiceScopes(String ipAddress) {
        return this.getServiceScopes();
    }

    public RdDeviceDeskPermissionResponse() {
    }

    public RdDeviceDeskPermissionResponse(Collection<RdDeviceDeskServiceScopeResponse> serviceScopes) {
        this.serviceScopes = serviceScopes;
    }

    public static RdDeviceDeskPermissionResponse create(Collection<RdDeviceDeskServiceScopeResponse> serviceScopes) {
        return new RdDeviceDeskPermissionResponse(serviceScopes);
    }

    public Collection<RdDeviceDeskServiceScopeResponse> getServiceScopes() {
        return this.serviceScopes;
    }

    public void setServiceScopes(Collection<RdDeviceDeskServiceScopeResponse> serviceScopes) {
        this.serviceScopes = serviceScopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdDeviceDeskPermissionResponse)) {
            return false;
        }
        RdDeviceDeskPermissionResponse other = (RdDeviceDeskPermissionResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Collection<RdDeviceDeskServiceScopeResponse> this$serviceScopes = this.getServiceScopes();
        Collection<RdDeviceDeskServiceScopeResponse> other$serviceScopes = other.getServiceScopes();
        return !(this$serviceScopes == null ? other$serviceScopes != null : !((Object)this$serviceScopes).equals(other$serviceScopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdDeviceDeskPermissionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<RdDeviceDeskServiceScopeResponse> $serviceScopes = this.getServiceScopes();
        result = result * 59 + ($serviceScopes == null ? 43 : ((Object)$serviceScopes).hashCode());
        return result;
    }

    public String toString() {
        return "RdDeviceDeskPermissionResponse(serviceScopes=" + this.getServiceScopes() + ")";
    }

    private static /* synthetic */ boolean lambda$getAllowedServiceScopes$2(String ipAddress, RdDeviceDeskServiceScopeResponse ii) {
        if (StringUtil.isEmpty((String)ii.getAssignedSuperviseDepartId()) || "*".equalsIgnoreCase(ii.getIpAddress())) {
            return true;
        }
        if (!StringUtil.isEmpty((String)ii.getAssignedSuperviseDepartId()) && StringUtil.isEmpty((String)ii.getIpAddress())) {
            return false;
        }
        if (StringUtil.isEmpty((String)ii.getIpAddress())) {
            return false;
        }
        return Arrays.stream(ii.getIpAddress().split(";")).anyMatch(ix -> ix.equalsIgnoreCase(ipAddress) || "*".equalsIgnoreCase((String)ix));
    }

    public static class RdDeviceDeskServiceScopeResponse
    extends ResponseAbstract {
        private String id;
        private String name;
        private String number;
        private Timestamp beginDate;
        private Timestamp endDate;
        private String boundEmployeeId;
        private String assignedSuperviseDepartId;
        private String ipAddress;
        private String organizationId;
        private String desc;
        private byte ir;

        public boolean isActive() {
            if (this.getBeginDate() == null || this.getEndDate() == null) {
                return false;
            }
            Date currentDate = Calendar.getInstance().getTime();
            return currentDate.after(this.getBeginDate()) && currentDate.before(this.getEndDate());
        }

        public RdDeviceDeskServiceScopeResponse() {
        }

        public RdDeviceDeskServiceScopeResponse(String id, String name, String number, Timestamp beginDate, Timestamp endDate, String boundEmployeeId, String assignedSuperviseDepartId, String ipAddress, String organizationId, String desc, byte ir) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.beginDate = beginDate;
            this.endDate = endDate;
            this.boundEmployeeId = boundEmployeeId;
            this.assignedSuperviseDepartId = assignedSuperviseDepartId;
            this.ipAddress = ipAddress;
            this.organizationId = organizationId;
            this.desc = desc;
            this.ir = ir;
        }

        public static RdDeviceDeskServiceScopeResponse create(String id, String name, String number, Timestamp beginDate, Timestamp endDate, String boundEmployeeId, String assignedSuperviseDepartId, String ipAddress, String organizationId, String desc, byte ir) {
            return new RdDeviceDeskServiceScopeResponse(id, name, number, beginDate, endDate, boundEmployeeId, assignedSuperviseDepartId, ipAddress, organizationId, desc, ir);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public Timestamp getBeginDate() {
            return this.beginDate;
        }

        public Timestamp getEndDate() {
            return this.endDate;
        }

        public String getBoundEmployeeId() {
            return this.boundEmployeeId;
        }

        public String getAssignedSuperviseDepartId() {
            return this.assignedSuperviseDepartId;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public String getDesc() {
            return this.desc;
        }

        public byte getIr() {
            return this.ir;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public void setBeginDate(Timestamp beginDate) {
            this.beginDate = beginDate;
        }

        public void setEndDate(Timestamp endDate) {
            this.endDate = endDate;
        }

        public void setBoundEmployeeId(String boundEmployeeId) {
            this.boundEmployeeId = boundEmployeeId;
        }

        public void setAssignedSuperviseDepartId(String assignedSuperviseDepartId) {
            this.assignedSuperviseDepartId = assignedSuperviseDepartId;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public void setIr(byte ir) {
            this.ir = ir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RdDeviceDeskServiceScopeResponse)) {
                return false;
            }
            RdDeviceDeskServiceScopeResponse other = (RdDeviceDeskServiceScopeResponse)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.getIr() != other.getIr()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$number = this.getNumber();
            String other$number = other.getNumber();
            if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
                return false;
            }
            Timestamp this$beginDate = this.getBeginDate();
            Timestamp other$beginDate = other.getBeginDate();
            if (this$beginDate == null ? other$beginDate != null : !((Object)this$beginDate).equals(other$beginDate)) {
                return false;
            }
            Timestamp this$endDate = this.getEndDate();
            Timestamp other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            String this$boundEmployeeId = this.getBoundEmployeeId();
            String other$boundEmployeeId = other.getBoundEmployeeId();
            if (this$boundEmployeeId == null ? other$boundEmployeeId != null : !this$boundEmployeeId.equals(other$boundEmployeeId)) {
                return false;
            }
            String this$assignedSuperviseDepartId = this.getAssignedSuperviseDepartId();
            String other$assignedSuperviseDepartId = other.getAssignedSuperviseDepartId();
            if (this$assignedSuperviseDepartId == null ? other$assignedSuperviseDepartId != null : !this$assignedSuperviseDepartId.equals(other$assignedSuperviseDepartId)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$organizationId = this.getOrganizationId();
            String other$organizationId = other.getOrganizationId();
            if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RdDeviceDeskServiceScopeResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIr();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : $number.hashCode());
            Timestamp $beginDate = this.getBeginDate();
            result = result * 59 + ($beginDate == null ? 43 : ((Object)$beginDate).hashCode());
            Timestamp $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            String $boundEmployeeId = this.getBoundEmployeeId();
            result = result * 59 + ($boundEmployeeId == null ? 43 : $boundEmployeeId.hashCode());
            String $assignedSuperviseDepartId = this.getAssignedSuperviseDepartId();
            result = result * 59 + ($assignedSuperviseDepartId == null ? 43 : $assignedSuperviseDepartId.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $organizationId = this.getOrganizationId();
            result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            return result;
        }

        public String toString() {
            return "RdDeviceDeskPermissionResponse.RdDeviceDeskServiceScopeResponse(id=" + this.getId() + ", name=" + this.getName() + ", number=" + this.getNumber() + ", beginDate=" + this.getBeginDate() + ", endDate=" + this.getEndDate() + ", boundEmployeeId=" + this.getBoundEmployeeId() + ", assignedSuperviseDepartId=" + this.getAssignedSuperviseDepartId() + ", ipAddress=" + this.getIpAddress() + ", organizationId=" + this.getOrganizationId() + ", desc=" + this.getDesc() + ", ir=" + this.getIr() + ")";
        }
    }
}

