/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CompanyLevel;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.OccupationType;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Set;

@Schema(name="EmployeeDetailResponse", title="EmployeeDetailResponse \u4fdd\u5b89\u5458\u8be6\u60c5\u4fe1\u606f")
public class EmployeeDetailResponse
extends ResponseAbstract {
    @Schema(name="id", title="\u4fdd\u5b89\u5458id")
    private final String id;
    @Schema(name="name", title="\u59d3\u540d")
    private final String name;
    @Schema(name="idCardNo", title="\u8eab\u4efd\u8bc1")
    private final String idCardNo;
    @Schema(name="contact", title="\u8054\u7cfb\u65b9\u5f0f")
    private final String contact;
    @Schema(name="organizationId", title="\u4fdd\u5b89\u5458\u6240\u5728\u516c\u53f8Id")
    private final String organizationId;
    @Schema(name="companyName", title="\u6240\u5728\u516c\u53f8")
    private final String companyName;
    @Schema(name="authenticatedStatus", title="\u5b9e\u540d\u8ba4\u8bc1\u72b6\u6001")
    private final String authenticatedStatusText;
    @Schema(hidden=true, name="dutyStatus", title="\u4fdd\u5b89\u5458\u7b7e\u5230\u72b6\u6001; None: \u79bb\u5c97(\u672a\u7b7e\u5230); SignIn: \u5728\u5c97; SignOut: \u79bb\u5c97(\u7b7e\u9000/\u79bb\u5f00\u9a7b\u52e4\u70b9)")
    private final DutySignInType dutyStatus;
    @Schema(name="militaryStatus", title="\u5175\u5f79\u60c5\u51b5")
    private final String militaryStatus;
    @Schema(name="securityCertificateNo", title="\u8d44\u683c\u8bc1\u7f16\u53f7")
    private final String securityCertificateNo;
    @Schema(name="latitude", title="\u4fdd\u5b89\u5458\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u4fdd\u5b89\u5458\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="securityStationId", title="\u9a7b\u52e4\u70b9Id")
    private final String securityStationId;
    @Schema(name="securityStationName", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String securityStationName;
    @Schema(name="tencentUserId", title="\u97f3\u89c6\u9891\u7684\u817e\u8bafUserId")
    private final String tencentUserId;
    @Schema(name="tenantImUserId", title="\u7528\u6237\u672c\u8eab\u7684\u817e\u8bafUserId")
    private final String tenantImUserId;
    @Schema(name="cid", title="APP\u8bbe\u5907Cid\u7684\u503c")
    private final String cid;
    @Schema(name="superviseDepartId", title="\u6240\u5728\u9a7b\u52e4\u7684\u76d1\u7ba1\u5f52\u5c5e\u4fe1\u606f")
    private final String superviseDepartId;
    @Schema(name="superviseDepartName", title="\u6240\u5728\u9a7b\u52e4\u7684\u76d1\u7ba1\u5f52\u5c5e\u540d\u79f0")
    private final String superviseDepartName;
    @Schema(name="isDevice", title="\u662f\u5426\u4e3a\u786c\u4ef6\u8bbe\u5907")
    private final boolean isDevice;
    private final Set<String> followedDeviceNos;
    @Schema(name="thirdParty", title="\u7b2c\u4e09\u65b9\u673a\u6784; \u6bd4\u5982: \u9a6c\u62c9\u677e\u4e2d\u7684\u5fd7\u613f\u8005\u3001\u533b\u62a4\u4eba\u5458\u3001\u88c1\u5224\u6765\u81ea\u7684\u5355\u4f4d\u4fe1\u606f")
    private String thirdParty;
    @Schema(name="isFollowed", title="\u662f\u5426\u5173\u6ce8")
    private final boolean followed;
    @Schema(name="securityStationRailIds", title="\u6d89\u53ca\u5230\u7535\u5b50\u56f4\u680f\u4fe1\u606f")
    private final Set<String> securityStationRailIds;
    @Schema(name="relativeSuperviseDepartIds", title="relativeSuperviseDepartIds")
    private final Set<String> relativeSuperviseDepartIds;
    @Schema(name="cLevels", title="\u6240\u5728\u4f01\u4e1a\u7ea7\u522b")
    private final Collection<CompanyLevel> cLevels;
    @Schema(name="stationResponsible", title="\u662f\u5426\u4e3a\u9a7b\u52e4\u70b9\u8d1f\u8d23\u4eba")
    private final boolean stationResponsible;
    @Schema(name="responsibleOfStationId", title="\u6240\u8d1f\u8d23\u7684\u9a7b\u52e4\u70b9Id; \u5982\u679c\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u9a7b\u52e4\u70b9\u8ddf\u8d1f\u8d23\u7684\u9a7b\u52e4\u70b9\u4e00\u81f4; \u5219\u8fd4\u56de\u5f53\u524d\u9a7b\u52e4\u70b9; \u5426\u5219\u8fd4\u56denull")
    private final String responsibleOfStationId;
    @Schema(name="resourceTypes", title="\u8d44\u6e90\u7c7b\u578b: Security=\u4fdd\u5b89;Population=\u793e\u4f1a\u529b\u91cf;Proprietor=\u5185\u4fdd\u5355\u4f4d\u7684\u7532\u65b9\u7ba1\u7406\u5458;ProprietorManaged=\u5185\u4fdd\u5355\u4f4d\u7ba1\u7406\u7684\u4fdd\u5b89\u4eba\u5458;TemporarySecurity=\u4e34\u4fdd;\u5982\u679c\u4e34\u4fdd\u8c03\u5ea6\u53f0\u7684\u8bdd, \u5219\u663e\u5f0f\u4e34\u4fdd\u4eba\u5458")
    private final Set<String> resourceTypes;
    @Schema(name="institutional", title="\u6240\u5c5e\u516c\u53f8\u7684\u673a\u6784\u7c7b\u578b")
    private final String institutional;
    @Schema(name="institutionalName", title="\u6240\u5c5e\u516c\u53f8\u7684\u673a\u6784\u7c7b\u578b\u540d\u79f0")
    private final String institutionalName;
    @Schema(name="proprietorCompanyId", title="\u6240\u670d\u52a1\u7684\u5185\u4fdd\u5355\u4f4dId")
    private final String proprietorCompanyId;
    @Schema(name="proprietorCompanyName", title="\u6240\u670d\u52a1\u7684\u5185\u4fdd\u5355\u4f4d\u4fe1\u606f")
    private final String proprietorCompanyName;
    @Schema(name="occupationType", title="\u4eba\u5458\u7c7b\u578b: \u6587\u5b57\u63cf\u8ff0; \u6bd4\u5982: \u4fdd\u5b89\u4eba\u5458/\u7532\u65b9\u7ba1\u7406\u5458/\u8b66\u5458/\u793e\u4f1a\u529b\u91cf/\u4e00\u822c\u804c\u5458/(\u4e34\u4fdd\u8c03\u5ea6\u53f0\u4e2d; \u5f53\u6b64\u503c\u4e3a'-'\u7684\u65f6\u5019; \u9700\u8981\u6839\u636estationType \u4e0e /security-stations/station-types \u4e2d\u8fd4\u56de\u7684id\u6bd4\u5bf9\uff0c\u5e76\u663e\u793aname\u7684\u503c)")
    private String occupationType;
    @Schema(name="stationType", title="\u6240\u5728\u5c97\u70b9\u7684\u7c7b\u578b: \u6bd4\u5982\uff1a\u9a6c\u62c9\u677e\u4e2d, \u6b64\u503c\u4f5c\u4e3a\u5de5\u4f5c\u4eba\u5458\u7c7b\u578b\u7684Id;\u53ef\u4ee5\u7528\u4e8e\u83b7\u53d6\u5de5\u4f5c\u7c7b\u578b\u7684\u540d\u79f0")
    private final String stationType;
    @Schema(name="lastSyncTime", title="\u6700\u540e\u540c\u6b65\u65f6\u95f4")
    private final Timestamp lastSyncTime;
    @Schema(name="scopePermissions", title="\u8c03\u8bd5: \u53ef\u88ab\u67e5\u8be2\u8303\u56f4")
    private final Set<String> scopePermissions;
    @Schema(name="domainAdmin", title="\u7ec4\u7ec7\u7ba1\u7406\u5458")
    private final boolean domainAdmin;
    @Schema(name="responsibleOfStationIds", title="\u8d1f\u8d23\u7684\u5168\u90e8\u5173\u8054\u9a7b\u52e4\u70b9\u5217\u8868;")
    private final Set<String> responsibleOfStationIds;
    @Schema(name="superviseRegionCode", title="\u76d1\u7ba1\u533a\u57df\u7f16\u7801;")
    private final String superviseRegionCode;
    @Schema(name="projectId", title="\u9879\u76eeId")
    private final String projectId;
    @Schema(name="projectName", title="\u9879\u76ee\u540d\u79f0")
    private final String projectName;
    @Schema(name="countOfStations", title="\u6240\u5728\u7684\u5de5\u4f5c\u70b9(\u70b9\u4f4d/\u5c97\u70b9/\u9a7b\u52e4\u70b9)")
    private final int countOfStations;
    private final String syncNote;

    @Schema(name="dutyStatusText", title="\u7b7e\u5230\u7684\u6587\u672c\u63cf\u8ff0; \u4fdd\u5b89\u5458\u7b7e\u5230\u72b6\u6001; None: \u79bb\u5c97(\u672a\u7b7e\u5230); SignIn: \u5728\u5c97; SignOut: \u79bb\u5c97(\u7b7e\u9000/\u79bb\u5f00\u9a7b\u52e4\u70b9)")
    public String getDutyStatusText() {
        if (this.getDutyStatus() == null) {
            return null;
        }
        return this.getDutyStatus() == DutySignInType.SignIn ? "\u5728\u5c97" : "\u79bb\u5c97";
    }

    public boolean getIsDevice() {
        return this.isDevice;
    }

    @Schema(name="certificateSituation", title="\u6301\u8bc1\u60c5\u51b5")
    public String getCertificateSituation() {
        if (!StringUtil.isEmpty((String)this.getSecurityCertificateNo()) && !"#1".equals(this.getSecurityCertificateNo())) {
            return "\u6301\u8bc1";
        }
        return "\u672a\u6301\u8bc1";
    }

    @Schema(name="hasResource", title="\u662f\u5426\u5177\u6709\u8c03\u5ea6\u8d44\u6e90")
    public boolean getHasResource() {
        return this.getTencentUserId() != null && this.getTencentUserId().length() > 0;
    }

    public EmployeeDetailResponse(String id, String name, Double latitude, Double longitude, String idCardNo, String contact, String organizationId, String companyName, String authenticatedStatusText, DutySignInType dutyStatus, Boolean dispatchable, Timestamp lastDutyStatusChangedTime, String militaryStatus, String securityCertificateNo, String securityStationId, String securityStationName, String tencentUserId, String tenantImUserId, String superviseDepartId, String cid, boolean isDevice, String superviseDepartName, Set<String> followedDeviceNos, String thirdParty, boolean followed, Set<String> securityStationRailIds, String responsibleOfStationId, Set<String> resourceTypes, String institutional, Set<String> relativeSuperviseDepartIds, String proprietorCompanyId, String proprietorCompanyName, OccupationType occupationType, Set<String> scopePermissions, Timestamp lastSyncTime, String syncNote, boolean domainAdmin, Set<String> responsibleOfStationIds, String superviseRegionCode, int cLevel, String projectId, String projectName, String stationType, Integer countOfStations) {
        this.id = id;
        this.name = name;
        this.thirdParty = thirdParty;
        this.projectId = projectId;
        this.projectName = projectName;
        int n = this.countOfStations = countOfStations == null ? 0 : countOfStations;
        if (GeoLocationValueType.isValidLocation((Double)latitude, (Double)longitude)) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = null;
            this.longitude = null;
        }
        this.idCardNo = StringUtil.isEmpty((String)idCardNo) ? "" : idCardNo;
        this.contact = StringUtil.isEmpty((String)contact) ? "" : contact;
        this.organizationId = organizationId;
        this.companyName = companyName;
        this.authenticatedStatusText = authenticatedStatusText;
        this.cLevels = CompanyLevel.getLevels((int)cLevel);
        this.syncNote = String.format("\u5728\u5c97\u72b6\u6001:%s;dispatchable=%s;\u65f6\u95f4=%s;note=%s", dutyStatus, dispatchable, lastDutyStatusChangedTime, syncNote);
        this.dutyStatus = dutyStatus == DutySignInType.SignIn ? (dispatchable != null && !dispatchable.booleanValue() ? DutySignInType.SignOut : dutyStatus) : dutyStatus;
        this.militaryStatus = militaryStatus;
        this.securityCertificateNo = StringUtil.isEmpty((String)securityCertificateNo) ? "" : securityCertificateNo;
        this.securityStationId = securityStationId;
        this.securityStationName = StringUtil.isEmpty((String)securityStationName) ? "" : securityStationName;
        this.tencentUserId = tencentUserId;
        this.tenantImUserId = tenantImUserId;
        this.superviseDepartId = superviseDepartId;
        this.cid = cid;
        this.isDevice = isDevice;
        this.superviseDepartName = superviseDepartName;
        this.followedDeviceNos = followedDeviceNos;
        this.followed = followed;
        this.securityStationRailIds = securityStationRailIds;
        this.stationResponsible = !StringUtil.isEmpty((String)responsibleOfStationId) && !"#1".equalsIgnoreCase(responsibleOfStationId);
        this.responsibleOfStationId = responsibleOfStationId;
        this.resourceTypes = resourceTypes;
        this.institutional = institutional;
        this.relativeSuperviseDepartIds = relativeSuperviseDepartIds;
        this.proprietorCompanyName = proprietorCompanyName;
        this.proprietorCompanyId = proprietorCompanyId;
        this.occupationType = RoleType.create((String)institutional, (String)companyName) == RoleType.Proprietor ? "\u7532\u65b9\u7ba1\u7406\u5458" : ("0201".equalsIgnoreCase(institutional) ? "-" : (this.getResourceTypes() != null && this.getResourceTypes().stream().allMatch(ii -> StringUtil.isEqual((String)ii, (String)ResourceType.Population.name())) ? "\u793e\u4f1a\u529b\u91cf" : (occupationType == null ? "" : occupationType.getTypeName())));
        this.institutionalName = BusinessUtil.getInstitutionalName((String)institutional);
        this.lastSyncTime = lastSyncTime;
        this.scopePermissions = scopePermissions;
        this.domainAdmin = domainAdmin;
        this.responsibleOfStationIds = responsibleOfStationIds;
        this.superviseRegionCode = superviseRegionCode;
        this.stationType = stationType;
    }

    public static EmployeeDetailResponse create(String id, String name, Double latitude, Double longitude, String idCardNo, String contact, String organizationId, String companyName, String authenticatedStatusText, DutySignInType dutyStatus, Boolean dispatchable, Timestamp lastDutyStatusChangedTime, String militaryStatus, String securityCertificateNo, String securityStationId, String securityStationName, String tencentUserId, String tenantImUserId, String superviseDepartId, String cid, boolean isDevice, String superviseDepartName, Set<String> followedDeviceNos, String thirdParty, boolean followed, Set<String> securityStationRailIds, String responsibleOfStationId, Set<String> resourceTypes, String institutional, Set<String> relativeSuperviseDepartIds, String proprietorCompanyId, String proprietorCompanyName, OccupationType occupationType, Set<String> scopePermissions, Timestamp lastSyncTime, String syncNote, boolean domainAdmin, Set<String> responsibleOfStationIds, String superviseRegionCode, int cLevel, String projectId, String projectName, String stationType, Integer countOfStations) {
        return new EmployeeDetailResponse(id, name, latitude, longitude, idCardNo, contact, organizationId, companyName, authenticatedStatusText, dutyStatus, dispatchable, lastDutyStatusChangedTime, militaryStatus, securityCertificateNo, securityStationId, securityStationName, tencentUserId, tenantImUserId, superviseDepartId, cid, isDevice, superviseDepartName, followedDeviceNos, thirdParty, followed, securityStationRailIds, responsibleOfStationId, resourceTypes, institutional, relativeSuperviseDepartIds, proprietorCompanyId, proprietorCompanyName, occupationType, scopePermissions, lastSyncTime, syncNote, domainAdmin, responsibleOfStationIds, superviseRegionCode, cLevel, projectId, projectName, stationType, countOfStations);
    }

    public void assignThirdPartyName(String thirdPartyName) {
        this.thirdParty = thirdPartyName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public String getContact() {
        return this.contact;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getAuthenticatedStatusText() {
        return this.authenticatedStatusText;
    }

    public DutySignInType getDutyStatus() {
        return this.dutyStatus;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public String getSecurityCertificateNo() {
        return this.securityCertificateNo;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public String getTencentUserId() {
        return this.tencentUserId;
    }

    public String getTenantImUserId() {
        return this.tenantImUserId;
    }

    public String getCid() {
        return this.cid;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public String getThirdParty() {
        return this.thirdParty;
    }

    public boolean isFollowed() {
        return this.followed;
    }

    public Set<String> getSecurityStationRailIds() {
        return this.securityStationRailIds;
    }

    public Set<String> getRelativeSuperviseDepartIds() {
        return this.relativeSuperviseDepartIds;
    }

    public Collection<CompanyLevel> getCLevels() {
        return this.cLevels;
    }

    public boolean isStationResponsible() {
        return this.stationResponsible;
    }

    public String getResponsibleOfStationId() {
        return this.responsibleOfStationId;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public String getInstitutional() {
        return this.institutional;
    }

    public String getInstitutionalName() {
        return this.institutionalName;
    }

    public String getProprietorCompanyId() {
        return this.proprietorCompanyId;
    }

    public String getProprietorCompanyName() {
        return this.proprietorCompanyName;
    }

    public String getOccupationType() {
        return this.occupationType;
    }

    public String getStationType() {
        return this.stationType;
    }

    public Timestamp getLastSyncTime() {
        return this.lastSyncTime;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public boolean isDomainAdmin() {
        return this.domainAdmin;
    }

    public Set<String> getResponsibleOfStationIds() {
        return this.responsibleOfStationIds;
    }

    public String getSuperviseRegionCode() {
        return this.superviseRegionCode;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public int getCountOfStations() {
        return this.countOfStations;
    }

    public String getSyncNote() {
        return this.syncNote;
    }
}

