/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import java.sql.Timestamp;
import java.util.Calendar;

public class ScheduledRollCallPlanSearchRequest
extends RequestAbstract {
    private Timestamp scheduledTime;
    private RepetitiveRule repetitiveRule;

    public static ScheduledRollCallPlanSearchRequest create(Timestamp scheduledTime) {
        ScheduledRollCallPlanSearchRequest req = new ScheduledRollCallPlanSearchRequest();
        req.setScheduledTime(scheduledTime);
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(scheduledTime);
        int weekday = nowCalendar.get(7);
        RepetitiveRule selectedRule = RepetitiveRule.Monday;
        switch (weekday) {
            case 2: {
                selectedRule = RepetitiveRule.Monday;
                break;
            }
            case 3: {
                selectedRule = RepetitiveRule.Tuesday;
                break;
            }
            case 4: {
                selectedRule = RepetitiveRule.Wednesday;
                break;
            }
            case 5: {
                selectedRule = RepetitiveRule.Thursday;
                break;
            }
            case 6: {
                selectedRule = RepetitiveRule.Friday;
                break;
            }
            case 7: {
                selectedRule = RepetitiveRule.Saturday;
                break;
            }
            case 1: {
                selectedRule = RepetitiveRule.Sunday;
                break;
            }
            default: {
                throw new NoAllowedTenantException();
            }
        }
        req.setRepetitiveRule(selectedRule);
        return req;
    }

    public Timestamp getScheduledTime() {
        return this.scheduledTime;
    }

    public RepetitiveRule getRepetitiveRule() {
        return this.repetitiveRule;
    }

    public void setScheduledTime(Timestamp scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public void setRepetitiveRule(RepetitiveRule repetitiveRule) {
        this.repetitiveRule = repetitiveRule;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledRollCallPlanSearchRequest)) {
            return false;
        }
        ScheduledRollCallPlanSearchRequest other = (ScheduledRollCallPlanSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Timestamp this$scheduledTime = this.getScheduledTime();
        Timestamp other$scheduledTime = other.getScheduledTime();
        if (this$scheduledTime == null ? other$scheduledTime != null : !((Object)this$scheduledTime).equals(other$scheduledTime)) {
            return false;
        }
        RepetitiveRule this$repetitiveRule = this.getRepetitiveRule();
        RepetitiveRule other$repetitiveRule = other.getRepetitiveRule();
        return !(this$repetitiveRule == null ? other$repetitiveRule != null : !this$repetitiveRule.equals(other$repetitiveRule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScheduledRollCallPlanSearchRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Timestamp $scheduledTime = this.getScheduledTime();
        result = result * 59 + ($scheduledTime == null ? 43 : ((Object)$scheduledTime).hashCode());
        RepetitiveRule $repetitiveRule = this.getRepetitiveRule();
        result = result * 59 + ($repetitiveRule == null ? 43 : $repetitiveRule.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScheduledRollCallPlanSearchRequest(scheduledTime=" + this.getScheduledTime() + ", repetitiveRule=" + this.getRepetitiveRule() + ")";
    }
}

